from django import forms
from iconolab.models import AnnotationRevision
import json

class MultipleTagsField(forms.TypedMultipleChoiceField):
    pass

class AnnotationRevisionForm(forms.ModelForm):
    tags = forms.CharField()
    comment = forms.CharField(widget=forms.Textarea)
    
    class Meta:
        model = AnnotationRevision
        fields = ('title', 'description', 'fragment')
        widgets = {
            'fragment': forms.HiddenInput(),
            'tags': forms.HiddenInput()
        }
    
    def tags_json(self):
        if self.instance:
            tags_list = []
            for tag_info in self.instance.tagginginfo_set.all():
                tags_list.append({
                    'tag_input': tag_info.tag.link,
                    'relevancy': tag_info.relevancy,
                    'accuracy': tag_info.accuracy
                })
            return json.dumps(tags_list)
        else:
            return '[]' 