/* Enabling us to resize a shape width a handler 
	#http://stackoverflow.com/questions/32390028/how-to-drag-and-resize-svg-rectangle-using-cursor-types
*/


var Resizer = function (paper, shape) {
	this.paper = paper;
	this.shape = shape;

	this.HANDLER_SIZE = 6;
	this.states = {};
	this.init();
}

var api = Resizer.prototype = {

	init: function () {
		alert(" radical - blaze ");
		this.showHandlers();
		this.bindEvents();
	},

	showHandlers: function () {
		/* show handler here */
		var bbox = this.shape.getBBox();
		var handleX = bbox.x - this.HANDLER_SIZE/2;
		var handleY = bbox.y - this.HANDLER_SIZE/2;
		handler = this.paper.rect(handleX, handleY, this.HANDLER_SIZE, this.HANDLER_SIZE).attr({fill: 'red'});
	},

	bindEvents: function () {
		this.shape.click(function () { alert("radical ..."); });
		this.shape.drag();
	}
}

module.exports = {

	apply_resize : function (paper, rect) {
		new Resizer(paper, rect);
	}
}