from django.template import Library
import sys

register = Library()

# {% transform_matrix 230 200 100 100 %}
@register.simple_tag
def transform_matrix(im_width=0, im_height=0, max_x=0, max_y=0):
	try :
		x_ratio = im_width / max_x
		y_ratio = im_height / max_y
		value_list = [x_ratio, 0, 0, y_ratio, 0, 0]
		matrix = ','.join([str(v) for v in value_list])
	except:
		matrix = ""

	return matrix

@register.filter
def clean_path(path):
	if not len(path):
		return ""
	else:
		path_infos = path.split(';')
		return path_infos[0] 
		