from django import forms
from django.utils.translation import ugettext_lazy as _
from django_comments_xtd.forms import XtdCommentForm
from django_comments_xtd.models import TmpXtdComment
from django_comments_xtd import get_model as get_comment_model
from django.contrib.contenttypes.models import ContentType
from django.conf import settings
from django.utils.encoding import force_text
from django.utils import timezone
from iconolab.models import MetaCategory

class IconolabCommentForm(XtdCommentForm):
    metacategories = forms.ModelMultipleChoiceField(widget=forms.CheckboxSelectMultiple, queryset=MetaCategory.objects.all(), required=False)
    email = forms.EmailField(required=False)
    
    def __init__(self, *args, **kwargs):
        super(IconolabCommentForm, self).__init__(*args, **kwargs)
        self.fields.pop('email')
    
    def get_comment_create_data(self):
        self.cleaned_data['email'] = ''
        data = super(IconolabCommentForm, self).get_comment_create_data()
        data.update({'user_email': ''})
        return data