import datetime
from haystack import indexes
from iconolab.models import Annotation, Image

class ImageIndex(indexes.SearchIndex, indexes.Indexable):
	text = indexes.CharField(document=True, use_template=True)

	title = indexes.CharField(model_attr='item__metadatas__title')
	description = indexes.CharField(model_attr='item__metadatas__description')
	collection = indexes.CharField(model_attr='item__collection__name')
	tags = indexes.MultiValueField()

	def get_model(self):
		return Image

	def prepare_tags(self, object):
		return ["radical", "you better", "yes"]

	def index_queryset(self, using=None):
		return self.get_model().objects.filter(created__lte=datetime.datetime.now())


class AnnotationIndex(indexes.SearchIndex, indexes.Indexable):

	##indexed field
	text = indexes.CharField(document=True, use_template=True)

	title = indexes.CharField(model_attr='current_revision__title')
	description = indexes.CharField(model_attr='current_revision__description')
	tags = indexes.MultiValueField(model_attr='tags')

	## tags
	def get_model(self):
		return Annotation

	def index_queryset(self, using=None):
		return self.get_model().objects.filter(created__lte=datetime.datetime.now())