from iconolab.models import AnnotationRevision, IconolabComment, AnnotationStats
from rest_framework import serializers

class AnnotationStatsSerializer(serializers.ModelSerializer):
    class Meta:
        model = AnnotationStats
        fields = ('submitted_revisions_count', 'awaiting_revisions_count', 'accepted_revisions_count', 'contributors_count', 'views_count', 'comments_count', 'tag_count')

class AnnotationRevisionSerializer(serializers.ModelSerializer):
    tags = serializers.SerializerMethodField('get_normalized_tags')
    annotation_guid = serializers.SerializerMethodField()
    stats = AnnotationStatsSerializer(source='annotation.stats')
    author = serializers.SerializerMethodField()

    def get_normalized_tags(self, obj):
        tags = []
        for tagging_info in obj.tagginginfo_set.all():
            tags.append({
                "tag_label": tagging_info.tag.label,
                "tag_link": tagging_info.tag.link,
                "accuracy": tagging_info.accuracy,
                "relevancy": tagging_info.relevancy,
            })
        return tags

    def get_annotation_guid(self, obj):
        return obj.annotation.annotation_guid

    def get_author(self, obj):
        return obj.author.username

    class Meta:
        model = AnnotationRevision
        fields = ('annotation_guid', 'title', 'description', 'fragment', 'tags', 'stats', 'created', 'author')

class IconolabCommentSerializer(serializers.ModelSerializer):
    allow_thread = serializers.BooleanField()
    class Meta:
        model = IconolabComment
        fields = '__all__'
