from django.conf import settings
from appconf import AppConf
from elasticsearch_dsl import analyzer, token_filter

french_elision = token_filter(
    'french_elision',
    type='elision',
    articles_case=True,
    articles=["l", "m", "t", "qu", "n", "s", "j", "d", "c", "jusqu", "quoiqu", "lorsqu", "puisqu"]
)
french_stemmer = token_filter(
    'french_stemmer',
    type="stemmer",
    language="light_french"
)
french_analyzer = analyzer(
    'french',
    tokenizer='standard',
    filter=['lowercase', 'asciifolding', french_elision, french_stemmer]
)

class IconolabConf(AppConf):


    INDEXES_CONFIG = {
        'items': {
            'name': 'iconolab_items',
            'number_of_shards': 1,
            'number_of_replicas': 0,
        },
        'annotations': {
            'name': 'iconolab_annotations',
            'number_of_shards': 1,
            'number_of_replicas': 0,
        }
    }

    INDEXES_DEFAULT_CONFIG = {
        'number_of_shards': 1,
        'number_of_replicas': 0
    }

    INDEXES_ANALYZER = {
        'items': french_analyzer,
        'annotations': french_analyzer
    }

    INDEXES_FIELD_ANALYZER = {
        'items': french_analyzer,
        'annotations': french_analyzer
    }

    INDEXES_QUERYSET_PAGINATION = 5000

    SEARCH_PAGE_SIZE = 10

    class Meta:
        prefix = 'iconolab'
