from django import forms
from django.utils.translation import ugettext_lazy as _
from django_comments_xtd.forms import XtdCommentForm
from django_comments_xtd.models import TmpXtdComment
from django_comments_xtd import get_model as get_comment_model
from django.contrib.contenttypes.models import ContentType
from django.conf import settings
from django.utils.encoding import force_text
from django.utils import timezone
from iconolab.models import MetaCategory
import logging

logger = logging.getLogger(__name__)

class MetaCategoryMultipleChoiceFields(forms.ModelMultipleChoiceField):
    def label_from_instance(self, obj):
        return obj.label

class IconolabCommentForm(XtdCommentForm):
    email = forms.EmailField(required=False)
    metacategories = MetaCategoryMultipleChoiceFields(widget=forms.CheckboxSelectMultiple, queryset=None, required=False)

    def __init__(self, *args, **kwargs):
        super(IconolabCommentForm, self).__init__(*args, **kwargs)
        self.collection = self.target_object.image.item.collection
        self.fields["metacategories"].queryset = self.collection.metacategories.all()
        self.fields.pop('email')

    def get_comment_create_data(self):
        self.cleaned_data['email'] = ''
        data = super(IconolabCommentForm, self).get_comment_create_data()
        data.update({'user_email': ''})
        return data
