from django.utils import timezone
from haystack import indexes
from iconolab.models import Annotation, Item

class ItemIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)

    collection = indexes.CharField(model_attr="collection")
    authors = indexes.CharField(model_attr="metadatas__authors")
    school = indexes.CharField(model_attr="metadatas__school")
    designation = indexes.CharField(model_attr="metadatas__designation")
    datation = indexes.CharField(model_attr="metadatas__datation")
    technics = indexes.CharField(model_attr="metadatas__technics")
    measurements = indexes.CharField(model_attr="metadatas__measurements")
    create_or_usage_location = indexes.CharField(model_attr="metadatas__create_or_usage_location")
    discovery_context = indexes.CharField(model_attr="metadatas__discovery_context")
    conservation_location = indexes.CharField(model_attr="metadatas__conservation_location")
    
    #tags = indexes.MultiValueField(model_attr="tag_labels")

    def get_model(self):
        return Item

    def index_queryset(self, using=None):
        return self.get_model().objects.filter()


class AnnotationIndex(indexes.SearchIndex, indexes.Indexable):

    ##indexed field
    text = indexes.CharField(document=True, use_template=True)
    title = indexes.CharField(model_attr="current_revision__title")
    description = indexes.CharField(model_attr="current_revision__description")
    collection = indexes.CharField(model_attr="image__item__collection") 
    tags = indexes.MultiValueField(model_attr="tag_labels")
    
    ## tags
    def get_model(self):
        return Annotation

    def index_queryset(self, using=None):
        return self.get_model().objects.filter(created__lte=timezone.now())