import 'expose?Vue!vue/dist/vue'
import "expose?jQuery!jquery"
import "expose?$!jquery"

import VueResource from 'vue-resource'
import Typeahead from './components/typeahead/Typeahead.vue'
import Cutout from './components/cutout'
import Zoomview from './components/zoomview/Zoomview.vue'
import MergeTool from './components/mergetool/MergeTool.vue'
import CollectionSelector from './components/collectionselector/CollectionSelector.vue'
import TabSelector from './components/collectionhome/tabselector/TabSelector.vue'
import DescriptionViewer from './components/collectionhome/descriptionviewer/DescriptionViewer.vue'
import DiffViewer from './components/diffviewer/diffviewer.vue'
import jsondiffpatch from 'jsondiffpatch'
import Editor from './components/editor'
import ColorButtons from './components/tagform/ColorButtons.vue'
import TagList from './components/tagform/TagList.vue'

const Diff = require('diff')
Vue.config.ignoredElements = ["mask"];
var iconolab = {
    Cutout : Cutout,
    JsDiff: Diff,
    JsonDiff: jsondiffpatch,
    CollectionSelector: CollectionSelector,
    TabSelector: TabSelector,
    DescriptionViewer: DescriptionViewer,
    VueComponents : {
        Typeahead: Typeahead,
        MergeTool: MergeTool,
        Zoomview: Zoomview,
        DiffViewer: DiffViewer,
        Editor: Editor,
        ColorButtons: ColorButtons,
        TagList: TagList
    }
};

Vue.component('color-buttons', ColorButtons);
Vue.component('image-annotator', Editor.Canvas);
Vue.component('annotation', Editor.Annotation);

if (!window.iconolab) {
    window.iconolab = iconolab;
}
