from django.shortcuts import HttpResponse, get_object_or_404, render
from iconolab.models import Annotation, Collection, Image
from django.http import Http404
from django.contrib.auth.decorators import login_required
from django.views.generic import View, RedirectView
from django.views.generic.base import ContextMixin
from django.core.urlresolvers import reverse
from .forms.annotations import AnnotationRevisionForm
from pprint import pprint

class GlobalHomepageView(View):
	def get(self, request, *args, **kwargs):
		# Handle homepage view here
		return render(request, 'iconolab/home.html');


class CollectionHomepageView(View, ContextMixin):
	def get(self, request, *args, **kwargs):
		context = super(CollectionHomepageView, self).get_context_data(**kwargs)
		context["collection_name"] = self.kwargs.get("collection_name", "")
		return render(request, 'iconolab/collection_home.html', context);


class ShowImageView(View, ContextMixin):
	
	def get(self, request, *args, **kwargs):
		context = super(ShowImageView, self).get_context_data(**kwargs)
		context["collection_name"] = self.kwargs.get("collection_name", "")
		context["image_ref"] = self.kwargs.get("image_ref", "")
		return render(request, 'iconolab/detail_image.html', context);


class ShowAnnotationView(View, ContextMixin):
	
	def get_context_data(self, **kwargs):
		context = super(ShowAnnotationView, self).get_context_data(**kwargs)
		context["collection_name"] = self.kwargs.get("collection_name", "")
		context["image_ref"] = self.kwargs.get("image_ref", "")
		context["annotation_guid"] = self.kwargs.get("annotation_guid", "")
		return context
	
	def check_kwargs(self, kwargs):
		try:
			collection = Collection.objects.get(name=kwargs.get("collection_name", ""))
		except Collection.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		try:
			image = Image.objects.get(image_ref=kwargs.get("image_ref", ""))
		except Image.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		try:
			annotation = Annotation.objects.get(annotation_guid=kwargs.get("annotation_guid", ""))
		except Annotation.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		return collection, image, annotation
	
	def get(self, request, *args, **kwargs):
		collection, image, annotation = self.check_kwargs(kwargs)
		self.check_kwargs(kwargs)
		context = self.get_context_data(**kwargs)
		context["annotation"] = annotation
		return render(request, 'iconolab/detail_annotation.html', context)

    
class CreateAnnotationView(View, ContextMixin):
	
	def get_context_data(self, **kwargs):
		context = super(CreateAnnotationView, self).get_context_data(**kwargs)
		context["collection_name"] = self.kwargs.get("collection_name", "")
		context["image_ref"] = self.kwargs.get("image_ref", "")
		return context
	
	def check_kwargs(self, kwargs):
		try:
			collection = Collection.objects.get(name=kwargs.get("collection_name", ""))
		except Collection.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		try:
			image = Image.objects.get(image_ref=kwargs.get("image_ref", ""))
		except Image.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		return collection, image
	
	def get(self, request, *args, **kwargs):
		collection, image = self.check_kwargs(kwargs)
		annotation_form = AnnotationRevisionForm()
		context = self.get_context_data(**kwargs)
		context["image"] = image
		context["form"] = annotation_form
		return render(request, 'iconolab/change_annotation.html', context) 
	
	def post(self, request, *args, **kwargs):
		collection, image = self.check_kwargs(kwargs)
		collection_name = kwargs["collection_name"]
		image_ref = kwargs["image_ref"]
		annotation_form = AnnotationRevisionForm(request.POST)
		if annotation_form.is_valid():
			author = request.user
			title = annotation_form.cleaned_data["title"]
			description = annotation_form.cleaned_data["description"]
			fragment = annotation_form.cleaned_data["fragment"]
			new_annotation = Annotation.objects.create_annotation(author, image, title=title, description=description, fragment=fragment, tags=None)
			return RedirectView.as_view(url=reverse("annotation_detail", kwargs={'collection_name': collection_name, 'image_ref': image_ref, 'annotation_guid': new_annotation.annotation_guid}))(request)
	
class EditAnnotationView(View, ContextMixin):
	
	def get_context_data(self, **kwargs):
		context = super(EditAnnotationView, self).get_context_data(**kwargs)
		context["collection_name"] = self.kwargs.get("collection_name", "")
		context["image_ref"] = self.kwargs.get("image_ref", "")
		context["annotation_guid"] = self.kwargs.get("annotation_guid", "")
		return context
	
	def check_kwargs(self, kwargs):
		try:
			collection = Collection.objects.get(name=kwargs.get("collection_name", ""))
		except Collection.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		try:
			image = Image.objects.get(image_ref=kwargs.get("image_ref", ""))
		except Image.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		try:
			annotation = Annotation.objects.get(annotation_guid=kwargs.get("annotation_guid", ""))
		except Annotation.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		return collection, image, annotation
	
	def get(self, request, *args, **kwargs):
		collection, image, annotation = self.check_kwargs(kwargs)
		annotation_form = AnnotationRevisionForm()
		context = self.get_context_data(**kwargs)
		context["image"] = image
		context["annotation"] = annotation
		context["form"] = annotation_form
		return render(request, 'iconolab/change_annotation.html', context) 
	
	def post(self, request, *args, **kwargs):
		collection, image, annotation = self.check_kwargs(kwargs)
		collection_name = kwargs["collection_name"]
		image_ref = kwargs["image_ref"]
		annotation_guid = kwargs["annotation_guid"]
		annotation_form = AnnotationRevisionForm(request.POST)
		if annotation_form.is_valid():
			revision_author = request.user
			revision_title = annotation_form.cleaned_data["title"]
			revision_description = annotation_form.cleaned_data["description"]
			revision_fragment = annotation_form.cleaned_data["fragment"]
			annotation.make_new_revision(revision_author, revision_title, revision_description, revision_fragment, None)
			return RedirectView.as_view(url=reverse("annotation_detail", kwargs={'collection_name': collection_name, 'image_ref': image_ref, 'annotation_guid': annotation_guid}))(request)


class MergeProposalView(View):
	
	def get(self, request, *args, **kwargs):
		# Handle merge form display here
		pass
	
	def post(self, request, *args, **kwargs):
		# Handle merge form submit here
		pass
	
	
class NotFoundErrorView(View):
	def get(self, request, *args, **kwargs):
		# Handle image display here
		pass