const path = require('path')
const webpack = require('webpack')
const ExtractTextPlugin = require('extract-text-webpack-plugin')
const UglifyJsPlugin = require('uglifyjs-webpack-plugin')
const projectRoot = path.resolve(__dirname)
const VueLoaderPlugin = require('vue-loader/lib/plugin')
const LodashModuleReplacementPlugin = require('lodash-webpack-plugin')
const BundleAnalyzerPlugin = require('webpack-bundle-analyzer').BundleAnalyzerPlugin

const cssLoaders = [{
  loader: 'css-loader',
  options: {
    module: true,
    localIdentName: '[local]'
  }
}]

const scssLoaders = [
  {
    loader: 'css-loader',
    options: {
      module: true,
      localIdentName: '[local]',
      importLoaders: 1
    }
  },
  {
    loader: 'resolve-url-loader'
  },
  {
    loader: 'postcss-loader'
  },
  {
    loader: 'sass-loader'
  }
]

module.exports = {
  entry: {
    vendor: [
      'jquery',
      'bootstrap'
    ],
    iconolab: [
      './src/main.js',
      './src/main.scss'
    ]
  },
  output: {
    path: path.join(__dirname, '/../../src/iconolab/static'),
    publicPath: '/static/',
    filename: 'iconolab/js/[name].js'
  },
  module: {
    rules: [{
      test: /\.vue$/,
      loader: 'vue-loader'
    },
    {
      test: /\.css$/,
      loader: ExtractTextPlugin.extract({
        fallback: 'style-loader',
        use: cssLoaders
      }),
      include: [
        path.join(__dirname, '/src'),
        /node_modules/
      ]
    },
    {
      test: /\.scss$/,
      loader: ExtractTextPlugin.extract({
        fallback: 'style-loader',
        use: scssLoaders
      }),
      include: [
        path.join(__dirname, '/src'),
        /node_modules/
      ]
    },
    {
      test: /\.js$/,
      use: [{
        loader: 'babel-loader',
        options: {
          presets: ['es2015'],
          plugins: ['transform-es2015-shorthand-properties', 'lodash']
        }
      }],
      exclude: /node_modules/,
      include: [
        path.join(projectRoot, 'src')
      ]
    },
    {
      test: /\.(png|jpg|gif|svg)$/,
      loader: 'file-loader',
      query: {
        name: '[name].[ext]?[hash]'
      }
    },
    {
      test: /\.(ttf|eot|svg|woff|woff2)(\?v=[0-9]\.[0-9]\.[0-9])?$/,
      loader: 'file-loader?name=[name].[ext]&publicPath=../fonts/&outputPath=iconolab/fonts/'
    },
    {
      test: require.resolve('snapsvg'),
      loader: 'imports-loader?this=>window,fix=>module.exports=0'
    },
    {
      test: require.resolve('jquery'),
      use: [{
        loader: 'expose-loader',
        options: 'JQuery'
      }, {
        loader: 'expose-loader',
        options: '$'
      }]
    },
    {
      test: require.resolve('vue/dist/vue.min'),
      use: [{
        loader: 'expose-loader',
        options: 'Vue'
      }]
    }
    ]},
  plugins: [
    new ExtractTextPlugin('iconolab/css/[name].css'),
    new VueLoaderPlugin(),
    new webpack.ProvidePlugin({
      $: 'jquery',
      jQuery: 'jquery',
      Popper: ['popper.js', 'default']
    }),
    new LodashModuleReplacementPlugin(),
    new webpack.ContextReplacementPlugin(/moment[\/\\]locale$/, /fr/)
  ],
  devServer: {
    port: 8001,
    contentBase: path.join(__dirname, '/../../src/iconolab'),
    publicPath: '/static/',
    stats: 'minimal',
    compress: true,
    headers: {
      'Access-Control-Allow-Origin': '*'
    },
    historyApiFallback: true
  },
  devtool: '#source-map',
  performance: { hints: false },
  optimization: {
    splitChunks: { // CommonsChunkPlugin()
      name: 'vendor'
    },
    minimizer: [
      new UglifyJsPlugin({
        uglifyOptions: {
          ie8: false,
          mangle: true,
          output: {
            comments: false,
            beautify: false
          },
          compress: true,
          warnings: false,
          ecma: 6
        },
        sourceMap: true
      })
    ]
  }
}

if (process.env.NODE_ENV === 'production') {
  module.exports.mode = 'production'
  module.exports.devtool = false
  // http://vue-loader.vuejs.org/en/workflow/production.html
  module.exports.plugins = (module.exports.plugins || []).concat([
    new webpack.DefinePlugin({
      'process.env': {
        'NODE_ENV': '"production"'
      }
    })
  ])
} else {
  module.exports.mode = 'development'
  module.exports.plugins = (module.exports.plugins || []).concat([
    new BundleAnalyzerPlugin()
  ])
}
