import Vue from 'vue/dist/vue.min'
import $ from 'jquery'

import Typeahead from './components/typeahead/Typeahead.vue'
import Cutout from './components/cutout'
import Zoomview from './components/zoomview/Zoomview.vue'
import MergeTool from './components/mergetool/MergeTool.vue'
import CollectionSelector from './components/collectionselector/CollectionSelector.vue'
import DiffViewer from './components/diffviewer/diffviewer.vue'
import jsondiffpatch from 'jsondiffpatch'
import Editor from './components/editor'
import ColorButtons from './components/tagform/ColorButtons.vue'
import TagList from './components/tagform/TagList.vue'
import 'bootstrap'
import 'vue-resource'

const Diff = require('diff')
Vue.config.ignoredElements = ['mask']

var iconolab = {
  Cutout: Cutout,
  JsDiff: Diff,
  JsonDiff: jsondiffpatch,
  CollectionSelector: CollectionSelector,
  VueComponents: {
    Typeahead: Typeahead,
    MergeTool: MergeTool,
    Zoomview: Zoomview,
    DiffViewer: DiffViewer,
    Editor: Editor,
    ColorButtons: ColorButtons,
    TagList: TagList
  }
}

Vue.component('color-buttons', ColorButtons)
Vue.component('image-annotator', Editor.Canvas)
Vue.component('annotation-form', Editor.AnnotationForm)
Vue.component('annotation-list', Editor.AnnotationList)
Vue.component('comment-list', Editor.CommentList)

$('.table-clickable').each(function () {
  var selector = $(this).data('selector')
  $(this).find('tr').on('click', function (e) {
    var href = $(this).find(selector).attr('href')
    window.location.replace(href)
  })
})

if (!window.iconolab) {
  window.iconolab = iconolab
}
