from django.contrib import admin
from reversion_compare.admin import CompareVersionAdmin


# Register your models here.
from iconolab.models import (Tag, Annotation, Collection, Image,
	Comment, CommentAttachement, MetaCategory, Activity, Notification)


class CommentAttachmentInline(admin.TabularInline):
	model = CommentAttachement
	extra = 1


class CommentAdmin(admin.ModelAdmin):
	inlines = [CommentAttachmentInline]


class AnnotationAdmin(CompareVersionAdmin):
	history_latest_first = True

#reversion
admin.site.register(Image)
admin.site.register(Collection)
admin.site.register(Tag)
admin.site.register(Annotation, AnnotationAdmin)
admin.site.register(MetaCategory)
admin.site.register(Comment, CommentAdmin)
admin.site.register(Activity)
admin.site.register(Notification)