## ICONOLAB ##

### 1. Configuration and setup

#### virtualenv

- Install pip
- Create a virtualenv for the project (using virtualenvwrapper is a good idea if possible). Python version is 3.5.1
- Run

    pip install -r requirements.txt


#### node.js

- Make sure nodejs is installed
- cd into iconolab/src/iconolab/static/iconolab/js and run

    npm install

- To recreate the bundle file that lives in dist/

    npm build

- To add a new js module, you can add it to the js/components folder and then run
    
    npm start

#### Django project setup

- Copy iconolab/src/settings/dev.py.tmpl into iconolab/src/settings/dev.py, adapt content to configuration
- cd into iconolab/src folder and run

    python manage.py migrate

to create database tables

- Run

    python manage.py createsuperuser

to create an admin user

#### Elasticsearch

Some objects in Iconolab are indexed and searched using ElasticSearch. You need to configure Haystack (see dev.py.tmpl, HAYSTACK_CONNECTIONS) and run:

    python manage.py rebuild_index


### 2. Development server

#### 2.1 Python server

- cd into the iconolab/src folder and run

    python manage.py runserver

By default, the app is accessible through http://127.0.0.1:8000/home

#### 2.2 Javascript development

- cd into the iconolab/src_js/iconolab-bundle folder and run

    npm install
    npm run start

This will serve the iconolab.js file in the iconolab/src/iconolab/static/js and update it on changes you make in the js code in src_js so you can
edit the code and debug it live in your browser

### 3. Importing initial data from CSV

Make sure to have the following in the same folder:

* All the images to import. The image names must match their respective item inventory number.
* A csv file that contains the metadata for the items you will import
* A json file for initializing the collection in the database. (Optional if you want to import images in an existing collection)
* A json file for the metacategories that will be linked to the collection.
* Ensure the folder settings.MEDIA_ROOT+/uploads/ exists

The following django manage.py command is used to import collection data and images:

```
python manage.py importimages <:export-csv-path> --delimiter <:delimiter> --encoding <:encoding> --collection-json <:collection_fixture_FILENAME> (OR --collection-id <:collection_id> if collection already exists in db) --metacategories-json <:metacategories_json_FILENAME>
```

Options:
- ```--delimiter```: the delimiter for the csv file. For special ascii characters add a # before the code. Supported special chars are 9 (tab), 29 (Group separator), 30 (Record separator), 31 (Unit separator)
- ```--encoding```: the encoding provided if the csv is not in utf-8. Exemple: 8859 for ISO-8859
- ```--collection-json```: the json file to create the collection from
- ```--collection-id```: the id of the collection to import into, it must already exist
- ```--metacategories-json```: the json file to create metacategories on the collection we're importing into
- ```--jpeg-quality```: the jpeg quality: default to the setting IMG_JPG_DEFAULT_QUALITY
- ```--no-jpg-conversion```: set to True so the command will not convert the images to jpg. Useful for pre-converted jpeg and especially when importing large image banks
- ```--img-filename-identifier```: the column from which the command will try to find images in the folder: use keys from the setting IMPORT_FIELDS_DICT. Default is "INV".
- ```--filename-regexp-prefix```: allows you to customize the way the command try to find images by specifying a regexp pattern to match *before* the identifier provided in img-filename-identifier. Defaults to .*
- ```--filename-regexp-suffix```: allows you to customize the way the command try to find images by specifying a regexp pattern to match *after* the identifier provided in img-filename-identifier. Defaults to [\.\-_].*
    
Notes: 
* The export csv path will be used to find everything else (images and fixtures files). 
* If the csv file is not encoded in utf-8, you MUST provide --encoding so the csv file can be read
* You MUST provide either --collection-json or --collection-id, else the command doesn't know to which collection the objects will belong to.
* To find all images for a given item, the command will try to match filenames according to the pattern build from the 3 options: filename-regexp-prefix+<value of img-filename-identifier>+filename-regexp-suffix. For instance by default, for an object with an INV of MIC.3.10, the files MIC.3.10.jpg and MIC.3.10.verso.jpg would be matched and linked to the object.
* The command will first parse the csv, then create the objects in the database (Item and ItemMetadata), then move the images to the settings.MEDIA_ROOT+/uploads/ folder after converting them to JPEG, then create the database objects for the images. The command will ignore any csv row that lacks an image or any csv row that already has a database entry for the collection (by default INV number is used to test if a database entry exists).

### 4. Updating already existing data

Another management command allows for editing data using only a .csv file. The command will go through the csv and update the metadatas for every objects it finds in the database with the csv row content.

```
python manage.py updatecollection --collection-id=<:id> --delimiter=<:delimiter> --encoding=<:encoding>
```

Options:
- ```--delimiter```: the delimiter for the csv file. For special ascii characters add a # before the code. Supported special chars are 9 (tab), 29 (Group separator), 30 (Record separator), 31 (Unit separator)
- ```--encoding```: the encoding provided if the csv is not in utf-8. Exemple: 8859 for ISO-8859
- ```--collection-id```: the id of the collection to import into, it must already exist


 ## TO-DOs
 
 * Add a stat object for items with the following stats (at least?)
     - contributors_count
     - annotations_count
     - comments_count
     - contribution_calls_count

 * Annotation validation: there is an example handler in signals/handler.py for validation an annotation
 
 * Admin interface: add a way to extract data for one or more annotation as .csv
 
 * Django admin:
     - Search annotation/item/image by guid
     - More complete infos per row for object lists

 * History view: to be able to visualize the history of a given annotation

 * Zoomed images:	
     - Zoomed images on annotation pages and item list pages (thumbnail sizes must be sorted out to be pre-generated for the list pages)

 * Fragment editor:
     - Identify usability issues
     - Rectangle selection as default
     - Add a way to define two or more shapes for one fragment 