from django.conf import settings
from django.core.mail import send_mail
from django.core.urlresolvers import reverse

class EmailManager():

    VERB_NEW_COMMENT = 'a écrit un commentaire sur votre annotation'
    VERB_NEW_REPLY = 'a répondu à votre commentaire'
    VERB_NEW_ANNOTATION = 'a proposé une révision sur votre annotation'
    VERB_ACCEPTED_REVISION = 'a étudié votre révision'
    VERB_REQUEST_FOR_CONTRIBUTION = 'a fait un appel à contribution'
    VERB_REQUEST_FOR_EXPERTISE = 'a fait un appel à expertise'

    def __message_content(self):
        return 'Connectez-vous pour voir les notifications \n\n' + settings.BASE_URL + reverse('user_notifications')

    def __send_mail(self, recipient, verb):
        send_mail(
            'Un utilisateur ' + verb,
            self.__message_content(),
            settings.CONTACT_EMAIL,
            [recipient.email]
        )

    def new_comment(self, recipient):
        self.__send_mail(recipient, self.VERB_NEW_COMMENT)

    def new_reply(self, recipient):
        self.__send_mail(recipient, self.VERB_NEW_REPLY)

    def new_revision(self, recipient):
        self.__send_mail(recipient, self.VERB_NEW_ANNOTATION)

    def accepted_revision(self, recipient):
        self.__send_mail(recipient, self.VERB_ACCEPTED_REVISION)

    def request_for_contribution(self, recipient):
        self.__send_mail(recipient, self.VERB_REQUEST_FOR_CONTRIBUTION)

    def request_for_expertise(self, recipient):
        self.__send_mail(recipient, self.VERB_REQUEST_FOR_EXPERTISE)
