from django.shortcuts import HttpResponse, get_object_or_404, render
from iconolab.models import Annotation, Collection
from django.http import Http404
from django.contrib.auth.decorators import login_required
from django.views.generic import View, RedirectView
from django.views.generic.base import ContextMixin
from django.core.urlresolvers import reverse
from .forms.annotations import AnnotationRevisionForm
from pprint import pprint

class GlobalHomepageView(View):
	def get(self, request, *args, **kwargs):
		# Handle homepage view here
		return render(request, 'iconolab/home.html');


class CollectionHomepageView(View, ContextMixin):
	def get(self, request, *args, **kwargs):
		context = super(CollectionHomepageView, self).get_context_data(**kwargs)
		context["collection_name"] = self.kwargs.get("collection_name", "")
		return render(request, 'iconolab/collection_home.html', context);


class ShowImageView(View):
	def get(self, request, *args, **kwargs):
		context = super(CollectionHomepageView, self).get_context_data(**kwargs)
		context["collection_name"] = self.kwargs.get("collection_name", "")
		context["image_ref"] = self.kwargs.get("image_ref", "")
		return render(request, 'iconolab/collection_home.html', context);


class ShowAnnotationView(View, ContextMixin):
	
	def get_context_data(self, **kwargs):
		context = super(ShowAnnotationView, self).get_context_data(**kwargs)
		context["collection_name"] = self.kwargs.get("collection_name", "")
		context["image_ref"] = self.kwargs.get("image_ref", "")
		context["annotation_guid"] = self.kwargs.get("annotation_guid", "")
		return context
	
	def check_kwargs(self, kwargs):
		try:
			collection = Collection.objects.get(name=kwargs.get("collection_name", ""))
		except Collection.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		try:
			annotation = Annotation.objects.get(annotation_guid=kwargs.get("annotation_guid", ""))
		except Annotation.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		return collection, annotation
	
	def get(self, request, *args, **kwargs):
		collection, annotation = self.check_kwargs(kwargs)
		self.check_kwargs(kwargs)
		context = self.get_context_data(**kwargs)
		context["annotation"] = annotation
		print(annotation)
		return render(request, 'iconolab/detail_annotation.html', context)

    
class CreateAnnotationView(View):
	
	def get(self, request, *args, **kwargs):
		print("test")
		return render(request, 'iconolab/change_annotation.html')
	
	def post(self, request, *args, **kwargs):
		# Handle annotation submit here
		pass
	
class EditAnnotationView(View, ContextMixin):
	
	def get_context_data(self, **kwargs):
		context = super(EditAnnotationView, self).get_context_data(**kwargs)
		context["collection_name"] = self.kwargs.get("collection_name", "")
		context["image_ref"] = self.kwargs.get("image_ref", "")
		context["annotation_guid"] = self.kwargs.get("annotation_guid", "")
		return context
	
	def check_kwargs(self, kwargs):
		try:
			collection = Collection.objects.get(name=kwargs.get("collection_name", ""))
		except Collection.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		try:
			annotation = Annotation.objects.get(annotation_guid=kwargs.get("annotation_guid", ""))
		except Annotation.DoesNotExist:
			return RedirectView.as_view(url=reverse("404error"))
		return collection, annotation
	
	def get(self, request, *args, **kwargs):
		collection, annotation = self.check_kwargs(kwargs)
		annotation_form = AnnotationRevisionForm()
		context = self.get_context_data(**kwargs)
		context["annotation"] = annotation
		context["form"] = annotation_form
		return render(request, 'iconolab/change_annotation.html', context) 
	
	def post(self, request, *args, **kwargs):
		collection, annotation = self.check_kwargs(kwargs)
		collection_name = kwargs["collection_name"]
		image_ref = kwargs["image_ref"]
		annotation_guid = kwargs["annotation_guid"]
		annotation_form = AnnotationRevisionForm(request.POST)
		if annotation_form.is_valid():
			revision_author = request.user
			revision_title = annotation_form.cleaned_data["title"]
			revision_description = annotation_form.cleaned_data["description"]
			revision_fragment = annotation_form.cleaned_data["fragment"]
			annotation.make_new_revision(revision_author, revision_title, revision_description, revision_fragment, None)
			return RedirectView.as_view(url=reverse("annotation_detail", kwargs={'collection_name': collection_name, 'image_ref': image_ref, 'annotation_guid': annotation_guid}))(request)


class MergeProposalView(View):
	
	def get(self, request, *args, **kwargs):
		# Handle merge form display here
		pass
	
	def post(self, request, *args, **kwargs):
		# Handle merge form submit here
		pass
	
	
class NotFoundErrorView(View):
	def get(self, request, *args, **kwargs):
		# Handle image display here
		pass