from iconolab.models import Comment, Annotation
from django.db.models import signals
from django.dispatch import receiver
from pprint import pprint
from notifications.signals import notify
from iconolab.utils import NotificationManager
import pprint


#handle metacategories

@receiver(signals.post_save, sender=Comment)
def handle_metacategory(sender, **kwargs):
	commentInstance = kwargs.get('instance')
	if commentInstance is not None:
		metacategories_list = [mcat.label for mcat in commentInstance.metacategories.all()]
		print(", ".join(metacategories_list))


@receiver(signals.post_save, sender=Annotation)
def handle_new_annotation(sender, **kwargs):
	object_instance = kwargs.get('instance')
	if object_instance is None:
		pass

	notification = NotificationManager.create_notification(object_instance.author, verb=NotificationManager.NEW_ANNOTATION)
	NotificationManager.notify(notification=notification)


