from iconolab.models import AnnotationRevision, IconolabComment
from rest_framework import serializers

class AnnotationRevisionSerializer(serializers.ModelSerializer):
    tags = serializers.SerializerMethodField('get_normalized_tags')
    annotation_guid = serializers.SerializerMethodField()

    def get_normalized_tags(self, obj):
        tags = []
        for tagging_info in obj.tagginginfo_set.all():
            tags.append({
                "tag_label": tagging_info.tag.label,
                "tag_link": tagging_info.tag.link,
                "accuracy": tagging_info.accuracy,
                "relevancy": tagging_info.relevancy,
            })
        return tags

    def get_annotation_guid(self, obj):
        return obj.annotation.annotation_guid

    class Meta:
        model = AnnotationRevision
        fields = ('annotation_guid', 'title', 'description', 'fragment', 'tags')


class IconolabCommentSerializer(serializers.ModelSerializer):
    class Meta:
        model = IconolabComment
        fields = '__all__'
