from django import forms
from haystack.forms import SearchForm
from iconolab.models import Image, Annotation




#def get_available_choices():

def get_selected_model(type):
	
	available_models = {
		'image': Image,
		'annotation': Annotation
	}

	return available_models[type]


class IconolabSearchForm(SearchForm):

	realm = forms.ChoiceField(required=False, choices=(("image","Image"), ("annotation","Annotation")) )
	
	def __init__(self, *args, **kwargs):
		
		super(IconolabSearchForm, self).__init__(*args, **kwargs)

	def get_realm_queryset(self, qs, realm):
		
		if realm == 'image':
			qs = qs.models(Image).load_all_queryset(Image, Image.objects.select_related('item', 'item__metadatas'))
			qs = qs.filter(collection='stdie')
		if realm == 'annotation':
			qs = qs.models(Annotation).load_all_queryset(Annotation, Annotation.objects.select_related('image', 'stats', 'current_revision', 'author'))
		return qs

	def search(self):
		
		selected_realm = self.cleaned_data.get("realm")
		selected_model = get_selected_model(selected_realm)
		#load all if q empty
		qs = super(IconolabSearchForm, self).search()
		if qs.count() == 0:
			return qs
		else:
			qs = self.get_realm_queryset(qs, selected_realm).load_all()
		return qs