from django import forms
from django.utils.translation import ugettext_lazy as _
from django_comments_xtd.forms import XtdCommentForm
from iconolab.models import MetaCategory

class IconolabCommentForm(XtdCommentForm):
    metacategories = forms.ModelMultipleChoiceField(queryset=MetaCategory.objects.all())
    
    def __init__(self, *args, **kwargs):
        super(IconolabCommentForm, self).__init__(*args, **kwargs)
        self.fields.pop('email')
    
    def get_comment_create_data(self):
        data = super(IconolabCommentForm, self).get_comment_create_data()
        data.update({'metacategories': self.cleaned_data['metacategories']})
        return data