from django.core.management.base import BaseCommand, CommandError
from iconolab.models import AnnotationStats, ImageStats

class Command(BaseCommand):
    help = "Re-calculates every stat of every stat object (except view_counts) according to the database state"
    
    def handle(self, *args, **kwargs):
        for ann_stats_obj in AnnotationStats.objects.all():
            ann_stats_obj.update_stats()
        for img_stats_obj in ImageStats.objects.all():
            img_stats_obj.update_stats()