from haystack.generic_views import SearchView
from iconolab.search_indexes.forms import IconolabSearchForm
from iconolab.search_indexes.query import IconolabRelatedQuerySet
from django.shortcuts import HttpResponse

from pprint import pprint

#override Search and Related QuerySet here
class IconolabSearchView(SearchView):
	form_class = IconolabSearchForm
	queryset = IconolabRelatedQuerySet()
	template_name = "search/default_search.html"
	paginate_by = 10
	load_all = True

	templates_map = {
		"image": "search/image_search.html",
		"annotation": "search/annotation_search.html"
	}

	def get(self, request, *args, **kwargs):
		self.current_realm = request.GET['realm']
		return super(IconolabSearchView, self).get(request,*args, **kwargs)

	def get_queryset(self):
		qs = super(IconolabSearchView, self).get_queryset()
		return qs

	def get_template_names(self):
		template = IconolabSearchView.templates_map[self.current_realm]
		if template is None:
			template = IconolabSearchView.template_name
				
		return [template]

	def get_context_data(self, *args, **kwargs):
		print("inside get_context_data", kwargs.get("q"))
		print(kwargs.items())
		context = super(IconolabSearchView, self).get_context_data(*args, **kwargs)
		context['collection_name'] = self.kwargs.get('collection_name', '')
		return context