# Generated by Django 2.0.5 on 2018-06-01 15:44

from django.db import migrations
import json



def copy_metadata(apps, schema_editor):
    ItemMetadata = apps.get_model('iconolab', 'ItemMetadata')
    for item_metadata in ItemMetadata.objects.all():
        new_metadata = {
            "authors" : item_metadata.authors,
            "school" : item_metadata.school,
            "field" : item_metadata.field,
            "designation" : item_metadata.designation,
            "datation" : item_metadata.datation,
            "technics" : item_metadata.technics,
            "measurements" : item_metadata.measurements,
            "create_or_usage_location" : item_metadata.create_or_usage_location,
            "discovery_context" : item_metadata.discovery_context,
            "conservation_location" : item_metadata.conservation_location,
            "photo_credits" : item_metadata.photo_credits,
            "inventory_number" : item_metadata.inventory_number,
            "joconde_ref" : item_metadata.joconde_ref
        }

        item_metadata.metadata = json.dumps(new_metadata)
        item_metadata.natural_key = item_metadata.joconde_ref
        item_metadata.save()

class Migration(migrations.Migration):

    dependencies = [
        ('iconolab', '0028_itemmetadata_metadata'),
    ]

    operations = [
        migrations.RunPython(copy_metadata),
    ]
