"""iconolab URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.9/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  url(r'^blog/', include('blog.urls'))
"""
from django.core.urlresolvers import reverse_lazy
from django.conf.urls import url, include
from django.contrib import admin
from django import views as django_views
from iconolab import views
from iconolab.search_indexes.views import IconolabSearchView
from . import settings

from django.conf.urls.static import static
from django.contrib.auth.decorators import login_required
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
import notifications.urls

urlpatterns = [
    url(r'^$', django_views.generic.RedirectView.as_view(url=reverse_lazy("home"))),
    url(r'^admin/', admin.site.urls),
    url(r'^home$', views.iconolab.GlobalHomepageView.as_view(), name="home"),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)$', views.iconolab.CollectionHomepageView.as_view(), name='collection_home'), # Home fond
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/items/(?P<item_guid>[^/]+)$', views.iconolab.ShowItemView.as_view(), name='item_detail'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/items/?$', django_views.generic.RedirectView.as_view(pattern_name="collection_home")),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/?$', django_views.generic.RedirectView.as_view(pattern_name="collection_home")),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)$', views.iconolab.ShowImageView.as_view(), name='image_detail'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/?$', django_views.generic.RedirectView.as_view(pattern_name="image_detail")),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/create$', login_required(views.iconolab.CreateAnnotationView.as_view()), name='annotation_create'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/detail$', views.iconolab.ShowAnnotationView.as_view(), name='annotation_detail'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/edit$', login_required(views.iconolab.EditAnnotationView.as_view()), name='annotation_edit'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/revisions/?$', django_views.generic.RedirectView.as_view(pattern_name="annotation_detail")),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/revisions/(?P<revision_guid>[^/]+)/detail', views.iconolab.ShowRevisionView.as_view(), name='revision_detail'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/revisions/(?P<revision_guid>[^/]+)/merge$', login_required(views.iconolab.MergeProposalView.as_view()), name='annotation_merge'),
    url(r'^user/(?P<slug>[a-z0-9\-]+)/home/?$', views.iconolab.UserHomeView.as_view(), name="user_home"),
    url(r'^user/notifications/all/?$', login_required(views.iconolab.UserNotificationsView.as_view()), name="user_notifications"),
    url(r'^errors/404', views.iconolab.NotFoundErrorView.as_view(), name="404error"),
    url(r'^help/', views.iconolab.HelpView.as_view(), name="iconolab_help"),
    url(r'^account/', include('iconolab.auth.urls', namespace='account')),
    url(r'^comments/', include('django_comments_xtd.urls')),
    url(r'^comments/annotation/post', views.comments.post_comment_iconolab, name="post_comment"),
    url('^user/notifications/', include(notifications.urls, namespace='notifications')),
    
    url(r'collections/(?P<collection_name>[a-z0-9\-]+)/search/(?P<model_type>[a-z0-9\-]+)', IconolabSearchView.as_view(), name="collection_with_model_search"),

    url(r'^search/(?P<model_type>[a-z0-9\-]+)', IconolabSearchView.as_view(), name="model_search"),

    url(r'collections/(?P<collection_name>[a-z0-9\-]+)/search', IconolabSearchView.as_view(), name="collection_haystack_search"),
    url(r'^search/$', IconolabSearchView.as_view(), name="haystack_search"),
    #url(r'^search/', include('haystack.urls'), name="search_iconolab"),
]

urlpatterns += staticfiles_urlpatterns()
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
