"""
Django settings for iconolab project.

Generated by 'django-admin startproject' using Django 1.9.5.

For more information on this file, see
https://docs.djangoproject.com/en/1.9/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.9/ref/settings/
"""

import os, logging

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

STATIC_ROOT = os.path.join(BASE_DIR, '../../web/static/site')
MEDIA_ROOT = os.path.join(BASE_DIR, '../../web/media')

#dev_mode useful for src_js
SRC_JS_PATH = os.path.join(BASE_DIR, '..', '..', 'src_js')
DEV_MODE = True

STATICFILES_DIRS = [
    os.path.join(BASE_DIR, 'static'),
    os.path.join(BASE_DIR, 'media'),
    SRC_JS_PATH,
]



STATICFILES_DIRS = [
    os.path.join(BASE_DIR, 'static'),
]
BASE_URL = ''
STATIC_URL = '/static/'
MEDIA_URL = '/media/'

LOGIN_URL = '/account/login/'

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.9/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '#8)+upuo3vc7fi15czxz53ml7*(1__q8hg=m&+9ylq&st1_kqv'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True
THUMBNAIL_DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',
    'django_comments',
    'django_comments_xtd',
    'haystack',
    'iconolab.apps.IconolabApp',
    'sorl.thumbnail',
    'notifications'
]



COMMENTS_APP = "django_comments_xtd"
COMMENTS_XTD_MODEL = "iconolab.models.IconolabComment"
COMMENTS_XTD_FORM_CLASS = 'iconolab.forms.comments.IconolabCommentForm'
COMMENTS_XTD_MAX_THREAD_LEVEL = 100
COMMENTS_PER_PAGE_DEFAULT = 10

SITE_ID = 1

MIDDLEWARE_CLASSES = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'reversion.middleware.RevisionMiddleware',
]

STATICFILES_DIRS = [
    os.path.join(BASE_DIR, 'static'),
    os.path.join(BASE_DIR, 'iconolab', 'media'),
]

MEDIA_URL = os.path.join(BASE_DIR, 'iconolab', 'media') + "/"

ROOT_URLCONF = 'iconolab.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(BASE_DIR,'iconolab','templates')],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'iconolab.wsgi.application'


# Database
# https://docs.djangoproject.com/en/1.9/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}

# Logging

LOG_FILE = os.path.abspath(os.path.join(BASE_DIR,"../../run/log/log.txt"))
LOG_LEVEL = logging.DEBUG
LOGGING = {
    'version': 1,
    'disable_existing_loggers': True,
    'filters': {
        'require_debug_false': {
            '()': 'django.utils.log.RequireDebugFalse'
        }
    },
    'formatters' : {
        'simple' : {
            'format': "%(asctime)s - %(levelname)s : %(message)s",
        },
        'semi-verbose': {
            'format': '%(levelname)s %(asctime)s %(module)s %(message)s'
        },
    },
    'handlers': {
        'mail_admins': {
            'level': 'ERROR',
            'filters': ['require_debug_false'],
            'class': 'django.utils.log.AdminEmailHandler'
        },
        'stream_to_console': {
            'level': LOG_LEVEL,
            'class': 'logging.StreamHandler'
        },
        'file': {
            'level': LOG_LEVEL,
            'class': 'logging.FileHandler',
            'filename': LOG_FILE,
            'formatter': 'semi-verbose',
        },
    },
    'loggers': {
        'django.request': {
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },
        'iconolab': {
            'handlers': ['file'],
            'level': LOG_LEVEL,
            'propagate': True,
        },
    }
}


# Haystack connection
HAYSTACK_CONNECTIONS = {
    'default': {
        'ENGINE': 'haystack.backends.elasticsearch_backend.ElasticsearchSearchEngine',
        'URL': 'http://127.0.0.1:9200/',
        'INDEX_NAME': 'haystack',
    },
}

# HAYSTACK_SIGNAL_PROCESSOR
HAYSTACK_SIGNAL_PROCESSOR = 'iconolab.search_indexes.signals.RevisionSignalProcessor'

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.filebased.FileBasedCache',
        'LOCATION': os.path.join(MEDIA_ROOT, 'cache'),
#        'BACKEND': 'django.core.cache.backends.memcached.MemcachedCache',
#        'LOCATION': 'unix:/var/run/memcached/memcached.socket',
#        'KEY_PREFIX': 'ldt',
    }
}
# Password validation
# https://docs.djangoproject.com/en/1.9/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/1.9/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


IMPORT_FIELDS_DICT = {
    "AUTR": [],
    "ECOLE": [],
    "TITR": ["Titre"],
    "DENO": [],
    "APPL": [],
    "PERI": ["Période"],
    "MILL": [],
    "EPOCH": [],
    "TECH": [],
    "DIMS": ["Dimensions"],
    "EPOCH": [],
    "LIEUX": [],
    "DECV": [],
    "LOCA": ["Localisation"],
    "PHOT": ["Photo"],
    "INV": ["No inventaire",],
    "REF": ["REFERENCE"],
}

INTERNAL_TAGS_URL = BASE_URL
JOCONDE_NOTICE_BASE_URL = "http://www.culture.gouv.fr/public/mistral/joconde_fr?ACTION=CHERCHER&FIELD_98=REF&VALUE_98="
