"""iconolab URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.9/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  url(r'^blog/', include('blog.urls'))
"""
from django.conf.urls import url, include
from django.contrib import admin
from notifications import urls
from . import views
from . import settings

from django.conf.urls.static import static
from django.contrib.staticfiles.urls import staticfiles_urlpatterns

urlpatterns = [
    url(r'^admin/', admin.site.urls),
    url(r'^home', views.index, name="home"),
    url(r'^annotation/(?P<pk>[0-9]+)/$', views.detail_annotation, name='annotation_detail'),
    url(r'^annotation/(?P<pk>[0-9]+)/fragment', views.draw_fragment, name='annotation_fragment'),
    url(r'^annotation/create', views.create_annotation, name='annotation_create'),
    url(r'^annotation/(?P<pk>[0-9]+)/edit', views.edit_annotation, name='annotation_edit'),

    url(r'^rest', include('restapi.urls')),
    url(r'^inbox/notifications/', include(urls, namespace='notifications')),
    url(r'^account/', include('iconolab.auth.urls', namespace='account')),
]

urlpatterns += staticfiles_urlpatterns()
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)