# -*- coding: utf-8 -*-
# Generated by Django 1.9.6 on 2016-05-11 12:01
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Annotation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255)),
                ('description', models.TextField(null=True)),
                ('fragment', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='Collection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('description', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('content', models.TextField()),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('target', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iconolab.Annotation')),
            ],
        ),
        migrations.CreateModel(
            name='CommentAttachement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attachment_type', models.IntegerField(choices=[(1, 'link'), (2, 'image'), (3, 'pdf')], default=1)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('data', models.TextField()),
                ('comment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='iconolab.Comment')),
                ('main_annotation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iconolab.Annotation')),
            ],
        ),
        migrations.CreateModel(
            name='Image',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('media', models.ImageField(height_field='height', upload_to='uploads/', width_field='width')),
                ('height', models.IntegerField()),
                ('width', models.IntegerField()),
                ('mimetype', models.CharField(blank=True, max_length=1024, null=True)),
                ('exif', models.TextField(blank=True, null=True)),
                ('collection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iconolab.Collection')),
            ],
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.SlugField()),
                ('link', models.URLField()),
                ('description', models.TextField()),
                ('source', models.CharField(max_length=50)),
            ],
        ),
        migrations.AddField(
            model_name='annotation',
            name='image',
            field=models.ForeignKey(default=0, on_delete=django.db.models.deletion.CASCADE, to='iconolab.Image'),
        ),
        migrations.AddField(
            model_name='annotation',
            name='tags',
            field=models.ManyToManyField(to='iconolab.Tag'),
        ),
    ]
