"""iconolab URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.9/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  url(r'^blog/', include('blog.urls'))
"""
from django.core.urlresolvers import reverse_lazy
from django.conf.urls import url, include

from django.contrib import admin
from django import views as django_views
from iconolab import views
from django.conf import settings

from django.conf.urls.static import static
from django.contrib.auth.decorators import login_required
from django.contrib.auth.views import password_reset, password_reset_done, password_reset_confirm, password_reset_complete
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
import notifications.urls

urlpatterns = [
    url(r'^$', django_views.generic.RedirectView.as_view(url=reverse_lazy("home"))),
    url(r'^admin/', admin.site.urls),
    url(r'^home$', views.objects.GlobalHomepageView.as_view(), name="home"),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)$', views.objects.CollectionHomepageView.as_view(), name='collection_home'), # Home fond
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/items/(?P<item_guid>[^/]+)$', views.objects.ShowItemView.as_view(), name='item_detail'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/items/?$', django_views.generic.RedirectView.as_view(pattern_name="collection_home")),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/?$', django_views.generic.RedirectView.as_view(pattern_name="collection_home")),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)$', views.objects.ShowImageView.as_view(), name='image_detail'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/?$', django_views.generic.RedirectView.as_view(pattern_name="image_detail")),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/create$', login_required(views.objects.CreateAnnotationView.as_view()), name='annotation_create'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/detail$', views.objects.ShowAnnotationView.as_view(), name='annotation_detail'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/readonly$', views.objects.ReadonlyAnnotationView.as_view(), name='annotation_readonly'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/edit$', login_required(views.objects.EditAnnotationView.as_view()), name='annotation_edit'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/revisions/?$', django_views.generic.RedirectView.as_view(pattern_name="annotation_detail")),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/revisions/(?P<revision_guid>[^/]+)/detail', views.objects.ShowRevisionView.as_view(), name='revision_detail'),
    url(r'^collections/(?P<collection_name>[a-z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/revisions/(?P<revision_guid>[^/]+)/merge$', login_required(views.objects.MergeProposalView.as_view()), name='annotation_merge'),

    url(r'^user/settings/?$', login_required(views.userpages.UserSettingsView.as_view()), name="user_settings"),
    url(r'^user/collections/?$', login_required(views.userpages.UserCollectionsView.as_view()), name="user_collections"),
    url(r'^user/notifications/', include(notifications.urls, namespace='notifications')),
    url(r'^user/(?P<slug>[a-z0-9\-]+)/?$', views.userpages.UserHomeView.as_view(), name="user_home"),
    url(r'^user/(?P<slug>[a-z0-9\-]+)/commented/?$', views.userpages.UserCommentedView.as_view(), name="user_commented"),
    url(r'^user/(?P<slug>[a-z0-9\-]+)/contributed/?$', views.userpages.UserContributedView.as_view(), name="user_contributed"),
    url(r'^user/(?P<slug>[a-z0-9\-]+)/annotations/?$', views.userpages.UserAnnotationsView.as_view(), name="user_annotations"),
    url(r'^user/adminpanel/(?P<collection_name>[a-z0-9\-]+)/$', views.userpages.UserCollectionAdminView.as_view(), name="user_admin_panel"),
    url(r'^user/notifications/all/?$', login_required(views.userpages.UserNotificationsView.as_view()), name="user_notifications"),

    url(r'^errors/404', views.misc.NotFoundErrorView.as_view(), name="404error"),

    url(r'^help/', views.misc.HelpView.as_view(), name="iconolab_help"),
    url(r'^glossary/', views.misc.GlossaryView.as_view(), name="iconolab_glossary"),
    url(r'^credits/', views.misc.CreditsView.as_view(), name="iconolab_credits"),
    url(r'^contributioncharter/', views.misc.ContributionCharterView.as_view(), name="iconolab_charter"),
    url(r'^legalmentions/', views.misc.LegalMentionsView.as_view(), name="iconolab_legals"),

    url(r'^account/', include('iconolab.auth.urls', namespace='account')),
    url(r'^password/reset$', password_reset, name='password_reset'),
    url(r'^password/reset/done$', password_reset_done, name='password_reset_done'),
    url(r'^password/reset/complete$', password_reset_complete, name='password_reset_complete'),
    url(r'^password/reset/(?P<uidb64>[0-9A-Za-z_\-]+)/(?P<token>[0-9A-Za-z]{1,13}-[0-9A-Za-z]{1,20})/$', password_reset_confirm, name='password_reset_confirm'),

    url(r'^search/', include('iconolab.search_indexes.urls', namespace='search_indexes')),
    url(r'^comments/', include('django_comments_xtd.urls')),
    url(r'^comments/annotation/post', views.comments.post_comment_iconolab, name="post_comment"),
    url(r'^comments/annotation/(?P<annotation_guid>[^/]+)/comment-form$', views.comments.get_comment_form, name="get_comment_form"),
    url(r'^comments/annotation/(?P<annotation_guid>[^/]+)/comments.json$', views.comments.get_annotation_comments_json, name="get_annotation_comments_json"),

    url(r'^compare/$', views.objects.TestView.as_view(), name="compare_view")
    #url(r'^search/', include('haystack.urls'), name="search_iconolab"),
]


if settings.DJANGO_RUNSERVER:
    urlpatterns += staticfiles_urlpatterns()
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
    #static url
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
