from django.db.models.signals import post_save
from notifications.signals import notify

class NotificationManager:

	NEW_ANNOTATION = 'Nouvelle annotation' 
	NEW_COMMENT = 'Nouveau commentaire'

	class Notification:

		def __init__(self, sender=None, verb=None):
			self.sender = sender
			self.verb = verb
			self.recipient = None
			self.target = None
			self.description = None

		def set_recipient(self, recipient):
			self.recipient = recipient
			
		def set_target(self, target):
			self.target = target

		def set_description(self, description):
			self.description = description

	@classmethod
	def create_notification(self, sender=None, verb=None):
		annotation = NotificationManager.Notification(sender, verb=verb)
		return annotation

	@classmethod
	def notify(self, notification=None):
		#send to all users or a Group
		notify.send(notification.sender, recipient=notification.sender, verb=notification.verb)