from django.apps import apps
from django.db.models.signals import post_save
from django.dispatch import Signal, receiver

from iconolab.models import Annotation, AnnotationRevision, IconolabComment

# Signal sent during method Annotation.validate_existing_revision to update stats
revision_accepted = Signal(providing_args=["instance"])
revision_created = Signal(providing_args=["instance"])


def increment_stats_on_new_revision(sender, instance, **kwargs):
    print("REVISION WAS CREATED")
    # Annotation stats
    annotation = instance.annotation
    annotation.stats.submitted_revisions_count += 1
    if instance.state in [AnnotationRevision.ACCEPTED, AnnotationRevision.STUDIED]:
        annotation.stats.accepted_revisions_count += 1
    annotation.stats.set_tags_stats()
    annotation.stats.save()
    # Image stats
    image = instance.annotation.image
    image.stats.submitted_revisions_count += 1
    image.stats.set_tags_stats()
    image.stats.save()

    
def increment_stats_on_new_comments(sender, instance, created, **kwargs):
    if created:
        model = apps.get_model(instance.content_type.app_label,instance.content_type.model)
        object_pk = instance.object_pk
        annotation = model._default_manager.get(pk=object_pk)
        annotation.stats.comments_count +=1
        annotation.stats.save()
        annotation.image.stats.comments_count +=1
        annotation.image.stats.save()


def increment_accepted_revisions(sender, instance, **kwargs):
    annotation = instance.annotation
    annotation.stats.accepted_revisions_count += 1
    annotation.stats.save()

def increment_annotations_count(sender, instance, created, **kwargs):
    if created:
        image = instance.image
        image.stats.annotations_count += 1
        image.stats.submitted_revisions_count += 1
        image.stats.set_tags_stats()
        image.stats.save()

post_save.connect(increment_annotations_count, sender=Annotation)
post_save.connect(increment_stats_on_new_comments, sender=IconolabComment)
revision_created.connect(increment_stats_on_new_revision, sender=AnnotationRevision)
revision_accepted.connect(increment_accepted_revisions, sender=AnnotationRevision)
        