from django.forms import ModelForm, TypedMultipleChoiceField, HiddenInput, MultipleHiddenInput
from iconolab.models import AnnotationRevision
import json

class MultipleTagsField(TypedMultipleChoiceField):
    pass

class AnnotationRevisionForm(ModelForm):
    class Meta:
        model = AnnotationRevision
        fields = ('title', 'description', 'fragment',)
        widgets = {
            'fragment': HiddenInput(),
            'tags': HiddenInput()
        }
    
    def tags_json(self):
        if self.instance:
            tags_list = []
            for tag_info in self.instance.tagginginfo_set.all():
                tags_list.push({
                    'tag_input': tag_info.tag.link,
                    'relevancy': tag_info.relevancy,
                    'accuracy': tag_info.accuracy
                })
            return json.dumps(tags_list)
        else:
            return '[]' 