# -*- coding: utf-8 -*-
# Generated by Django 1.9.7 on 2016-06-27 13:20
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('django_comments_xtd', '0001_initial'),
        ('iconolab', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CommentAttachement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('attachment_type', models.IntegerField(choices=[(0, 'link'), (1, 'image'), (2, 'pdf')], default=0)),
                ('data', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='IconolabComment',
            fields=[
                ('xtdcomment_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='django_comments_xtd.XtdComment')),
            ],
            options={
                'permissions': [('can_moderate', 'Can moderate comments')],
                'verbose_name': 'comment',
                'verbose_name_plural': 'comments',
                'abstract': False,
                'ordering': ('submit_date',),
            },
            bases=('django_comments_xtd.xtdcomment',),
        ),
        migrations.CreateModel(
            name='MetaCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(max_length=255)),
                ('collection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iconolab.Collection')),
            ],
        ),
        migrations.CreateModel(
            name='MetaCategoryInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('comment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iconolab.IconolabComment')),
                ('metacategory', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iconolab.MetaCategory')),
            ],
        ),
        migrations.AddField(
            model_name='iconolabcomment',
            name='metacategories',
            field=models.ManyToManyField(blank=True, null=True, through='iconolab.MetaCategoryInfo', to='iconolab.MetaCategory'),
        ),
        migrations.AddField(
            model_name='iconolabcomment',
            name='revision',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='creation_comment', to='iconolab.AnnotationRevision'),
        ),
        migrations.AddField(
            model_name='commentattachement',
            name='comment',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attachments', to='iconolab.IconolabComment'),
        ),
    ]
