from haystack.query import RelatedSearchQuerySet
from iconolab.models import Annotation, Image
from pprint import pprint

class IconolabRelatedQuerySet(RelatedSearchQuerySet):
	def __init__(self, using=None, query=None):
		super(IconolabRelatedQuerySet, self).__init__(using=using, query=query)

	def in_bulk(self, ids):
		results = {}
		int_ids = [ int(id) for id in ids]
		annotations = Annotation.objects.filter(pk__in = int_ids)
		
		for annotation in annotations:
			results[annotation.pk] = annotation
			
		return results
