import imp
import os.path
import StringIO

import config  # @UnusedImport
from fablib import (export_version, do_sync_web, create_config,
                    clean_export_folder, do_sync_comp, sync_install_build, do_create_virtualenv,
                    clean_rsync_folder, rsync_export, get_src_version, sync_build,
                    do_relaunch_server, install_build, do_create_virtualenv_requirement, build_src)
from fabric.api import task, env, run, cd, put
from fabric.colors import green

env.use_ssh_config = True

def build_source(version):
    print(green("build source with version %s" % version))
    export_path = export_version(iconolab=version)
    export_path_full = os.path.join(export_path, env.key, env.repos[env.key]['src_root'])
    build_src(export_path_full)
    (_,version_str) = get_src_version(env.key, export_path_full)
    return os.path.join(export_path_full,"dist","%s-%s.tar.gz" % (env.key,version_str))

def do_create_virtualenv(remote_build_folder):
    requirements_path = os.path.join(remote_build_folder, env.repos[env.key]['requirements'])
    do_create_virtualenv_requirement(requirements_path, env.remote_path['virtualenv'], env.repos[env.key]['python_version'])
    # add setting path to virtualenv
    ext_path = "import sys; sys.__plen = len(sys.path)\n"
    for l in env.remote_path.get('pythonpath', []):
        ext_path += l + "\n"
    ext_path += "import sys; new=sys.path[sys.__plen:]; del sys.path[sys.__plen:]; p=getattr(sys,'__egginsert',0); sys.path[p:p]=new; sys.__egginsert = p+len(new)"
    put(StringIO.StringIO(ext_path), os.path.join(env.remote_path['virtualenv'], 'lib/python%s/site-packages/_virtualenv_path_extensions.pth'%env.repos[env.key]['python_version']))

@task
def relaunch_server(do_collectstatic=True, do_migrate=True, do_check_folder_access=False):
    print("Relaunch server")
    do_relaunch_server(do_collectstatic, do_migrate, env.get('check_folder_access',do_check_folder_access))

@task
def sync_site(version):
    print(green("sync site and rebuild virtualenv with version %s" % version))
    build_path = build_source(version)
    run('mkdir -p "%s"' % env.remote_path['build_export'])
    res_trans = sync_build(build_path)
    # untar build
    with cd(env.remote_path['build_export']):
        run('tar zxf %s' % res_trans[0])

    do_create_virtualenv(res_trans[0][0:-7])

    # install build
    install_build(res_trans[0], env.remote_path['virtualenv'])

    # remove build + untared folder
    run('rm -fr "%s" "%s" ' % (res_trans[0], res_trans[0][0:-7]))
    clean_export_folder(env.remote_path['build_export'])
    relaunch_server()

@task
def create_virtualenv(version):
    build_path = build_source(version)
    run('mkdir -p "%s"' % env.remote_path['build_export'])
    res_trans = sync_build(build_path)
    # untar build
    with cd(env.remote_path['build_export']):
        run('tar zxf %s' % res_trans[0])

    do_create_virtualenv(res_trans[0][0:-7])

    run('rm -fr "%s" "%s" ' % (res_trans[0], res_trans[0][0:-7]))
    clean_export_folder(env.remote_path['build_export'])

@task
def sync_site_module(version):
    print(green("sync site with version %s" % version))
    build_path = build_source(version)
    run('mkdir -p "%s"' % env.remote_path['build_export'])
    res_trans = sync_build(build_path)
    # install build
    install_build(res_trans[0], env.remote_path['virtualenv'], env.platform_web_module)

    # remove build + untared folder
    run('rm -fr "%s"' % (res_trans[0]))
    clean_export_folder(env.remote_path['build_export'])
    relaunch_server()
