from django.apps import apps
from django.db.models.signals import post_save
from django.dispatch import Signal, receiver


# Signal sent during method Annotation.validate_existing_revision to update stats
revision_accepted = Signal(providing_args=["instance"])
revision_created = Signal(providing_args=["instance"])


def increment_stats_on_new_revision(sender, instance, **kwargs):
    from iconolab.models import AnnotationRevision
    if sender == AnnotationRevision:
        # Annotation stats
        annotation = instance.annotation
        annotation.stats.submitted_revisions_count += 1
        if instance.state in [AnnotationRevision.ACCEPTED, AnnotationRevision.STUDIED]:
            annotation.stats.accepted_revisions_count += 1
        annotation.stats.set_tags_stats()
        annotation.stats.save()
        # Image stats
        image = instance.annotation.image
        image.stats.submitted_revisions_count += 1
        image.stats.set_tags_stats()
        image.stats.save()

    
def increment_stats_on_new_comments(sender, instance, created, **kwargs):
    from iconolab.models import IconolabComment
    if created and sender == IconolabComment:
        model = apps.get_model(instance.content_type.app_label,instance.content_type.model)
        object_pk = instance.object_pk
        annotation = model._default_manager.get(pk=object_pk)
        annotation.stats.comments_count +=1
        annotation.stats.save()
        annotation.image.stats.comments_count +=1
        annotation.image.stats.save()


def increment_accepted_revisions(sender, instance, **kwargs):
    from iconolab.models import AnnotationRevision
    if sender == AnnotationRevision:
        annotation = instance.annotation
        annotation.stats.accepted_revisions_count += 1
        annotation.stats.save()

def increment_annotations_count(sender, instance, created, **kwargs):
    from iconolab.models import Annotation
    if created and sender == Annotation:
        image = instance.image
        image.stats.annotations_count += 1
        image.stats.submitted_revisions_count += 1
        image.stats.set_tags_stats()
        image.stats.save()

post_save.connect(increment_annotations_count)
post_save.connect(increment_stats_on_new_comments)
revision_created.connect(increment_stats_on_new_revision)
revision_accepted.connect(increment_accepted_revisions)
        