from django.apps import AppConfig

class IconolabApp(AppConfig):
    name = 'iconolab'
    verbose_name = 'Iconolab'

    def ready(self):
        import iconolab.signals.handlers
        import iconolab.templatetags.iconolab_tags
        from iconolab.conf import settings as iconolab_settings
        from django.conf import settings
        from PIL import Image
        if settings.ICONOLAB_MAX_IMAGE_PIXELS and settings.ICONOLAB_MAX_IMAGE_PIXELS > 0:
            Image.MAX_IMAGE_PIXELS = settings.ICONOLAB_MAX_IMAGE_PIXELS
        elif settings.ICONOLAB_MAX_IMAGE_PIXELS and settings.ICONOLAB_MAX_IMAGE_PIXELS <= 0:
            Image.MAX_IMAGE_PIXELS = None
            Image.warnings.simplefilter('ignore', Image.DecompressionBombWarning)
