"""iconolab URL Configuration
"""
import notifications.urls
from django import views as django_views
from django.conf import settings
from django.conf.urls.static import static
from django.contrib import admin
from django.contrib.auth.decorators import login_required
from django.contrib.auth.views import (password_reset, password_reset_complete,
                                       password_reset_confirm,
                                       password_reset_done)
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from django.urls import include, path, re_path, reverse_lazy

from iconolab import views

urlpatterns = [
    path(r'home', views.objects.GlobalHomepageView.as_view(), name="home"),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)$', views.objects.CollectionHomepageView.as_view(), name='collection_home'), # Home fond
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/items/(?P<item_guid>[^/]+)$', views.objects.ShowItemView.as_view(), name='item_detail'),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/items/?$', django_views.generic.RedirectView.as_view(pattern_name="collection_home")),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/?$', django_views.generic.RedirectView.as_view(pattern_name="collection_home")),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/(?P<image_guid>[^/]+)$', views.objects.ShowImageView.as_view(), name='image_detail'),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/(?P<image_guid>[^/]+)/bookmark/?$', views.objects.BookmarkImageView.as_view(), name='image_bookmark'),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/?$', django_views.generic.RedirectView.as_view(pattern_name="image_detail")),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/create$', login_required(views.objects.CreateAnnotationView.as_view()), name='annotation_create'),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/?$', views.objects.ShowAnnotationView.as_view(), name='annotation_detail'),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/detail$', views.objects.ShowAnnotationViewOld.as_view(), name='annotation_detail_old'),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/readonly$', views.objects.ReadonlyAnnotationView.as_view(), name='annotation_readonly'),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/edit$', login_required(views.objects.EditAnnotationView.as_view()), name='annotation_edit'),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/revisions/?$', views.objects.ShowRevisionsView.as_view(), name='annotation_revisions'),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/revisions/(?P<revision_guid>[^/]+)/detail', views.objects.ShowRevisionView.as_view(), name='revision_detail'),
    re_path(r'^collections/(?P<collection_name>[a-zA-Z0-9\-]+)/images/(?P<image_guid>[^/]+)/annotations/(?P<annotation_guid>[^/]+)/revisions/(?P<revision_guid>[^/]+)/merge$', login_required(views.objects.MergeProposalView.as_view()), name='annotation_merge'),

    re_path(r'^user/settings/?$', login_required(views.userpages.UserSettingsView.as_view()), name="user_settings"),
    re_path(r'^user/collections/?$', login_required(views.userpages.UserCollectionsView.as_view()), name="user_collections"),
    path(r'user/notifications/', include(notifications.urls, namespace='notifications')),
    re_path(r'^user/(?P<slug>[\w.@+-]+)/?$', views.userpages.UserHomeView.as_view(), name="user_home"),
    re_path(r'^user/(?P<slug>[\w.@+-]+)/commented/?$', views.userpages.UserCommentedView.as_view(), name="user_commented"),
    re_path(r'^user/(?P<slug>[\w.@+-]+)/contributed/?$', views.userpages.UserContributedView.as_view(), name="user_contributed"),
    re_path(r'^user/(?P<slug>[\w.@+-]+)/annotations/?$', views.userpages.UserAnnotationsView.as_view(), name="user_annotations"),
    re_path(r'^user/(?P<slug>[\w.@+-]+)/bookmarks/?$', views.userpages.UserBookmarksView.as_view(), name="user_bookmarks"),
    re_path(r'^bookmarks/(?P<bookmark>[0-9]+)/delete/?$', views.userpages.BookmarkDeleteView.as_view(), name="bookmark_delete"),
    re_path(r'^bookmarks/(?P<bookmark>[0-9]+)/edit/?$', views.userpages.BookmarkEditView.as_view(), name="bookmark_edit"),
    re_path(r'^user/adminpanel/(?P<collection_name>[a-zA-Z0-9\-]+)/$', views.userpages.UserCollectionAdminView.as_view(), name="user_admin_panel"),
    re_path(r'^user/notifications/all/?$', login_required(views.userpages.UserNotificationsView.as_view()), name="user_notifications"),

    path(r'errors/404', views.misc.NotFoundErrorView.as_view(), name="404error"),
    path(r'help/', views.misc.HelpView.as_view(), name="iconolab_help"),
    path(r'glossary/', views.misc.GlossaryView.as_view(), name="iconolab_glossary"),

    path(r'account/', include('iconolab.auth.urls', namespace='account')),
    path(r'password/reset', password_reset, name='password_reset'),
    path(r'password/reset/done', password_reset_done, name='password_reset_done'),
    path(r'password/reset/complete', password_reset_complete, name='password_reset_complete'),
    re_path(r'^password/reset/(?P<uidb64>[0-9A-Za-z_\-]+)/(?P<token>[0-9A-Za-z]{1,13}-[0-9A-Za-z]{1,20})/$', password_reset_confirm, name='password_reset_confirm'),

    path(r'search/', include('iconolab.search_indexes.urls', namespace='search_indexes')),
    path(r'comments/', include('django_comments_xtd.urls')),
    path(r'comments/annotation/post', views.comments.post_comment_iconolab, name="post_comment"),
    re_path(r'^comments/annotation/(?P<annotation_guid>[^/]+)/comment-form$', views.comments.get_comment_form, name="get_comment_form"),
    re_path(r'^comments/annotation/(?P<annotation_guid>[^/]+)/comments.json$', views.comments.get_annotation_comments_json, name="get_annotation_comments_json"),

    path(r'compare/', views.objects.TestView.as_view(), name="compare_view")
]
