import imp
import os.path
import io

# import config  # @UnusedImport
# from fablib import (export_version, do_sync_web, create_config,
#                     clean_export_folder, do_sync_comp, sync_install_build, do_create_virtualenv,
#                     clean_rsync_folder, rsync_export, get_src_version, sync_build,
#                     do_relaunch_server, install_build, do_create_virtualenv_requirement, build_src)
from core import (export_version, build_src, get_src_version, sync_build,
                  do_create_virtualenv_requirement, get_src_dependencies,
                  do_relaunch_server, clean_export_folder)
# from fabric import task, env, run, cd, put
from fabric import Connection
from invoke import task
from blessings import Terminal
# from fabric.colors import green

# env.use_ssh_config = True

t = Terminal()

def build_source(c, key, version):
    print(t.green("build source with version %s" % version))
    export_path = export_version(c, **{ key: version })
    export_path_full = os.path.join(export_path, key, c.env.repos[key]['src_root'])
    build_src(c, export_path_full)
    (_,version_str) = get_src_version(c, key, export_path_full)
    src_dep = get_src_dependencies(c, key, export_path_full)
    return (os.path.join(export_path_full,"dist","%s-%s.tar.gz" % (key,version_str)), src_dep)


def do_create_virtualenv(c, remote_build_path, dep_remote_build_path_list):
    env = c.env
    requirements_path = os.path.join(remote_build_path, env['repos'][env.key]['requirements'])
    remotevirtualenvpath = env['remote_path']['virtualenv']
    do_create_virtualenv_requirement(c, requirements_path, remotevirtualenvpath, env['repos'][env.key]['python_version'])
    # add setting path to virtualenv
    ext_path = "import sys; sys.__plen = len(sys.path)\n"
    for l in env['remote_path'].get('pythonpath', []):
        ext_path += l + "\n"
    ext_path += "import sys; new=sys.path[sys.__plen:]; del sys.path[sys.__plen:]; p=getattr(sys,'__egginsert',0); sys.path[p:p]=new; sys.__egginsert = p+len(new)"
    with Connection(env['hosts'][0]) as rconnection:
        rconnection.put(io.StringIO(ext_path), os.path.join(env['remote_path']['virtualenv'], 'lib/python%s/site-packages/_virtualenv_path_extensions.pth'%env['repos'][env.key]['python_version']))
        for dep_remote_build_path in dep_remote_build_path_list:
            with rconnection.prefix("echo $SHELL && . \"%s\"" % os.path.join(remotevirtualenvpath, "bin/activate")):
                rconnection.run("pip install \"%s\"" % dep_remote_build_path)
        with rconnection.prefix("echo $SHELL && . \"%s\"" % os.path.join(remotevirtualenvpath, "bin/activate")):
            rconnection.run("pip install \"%s.tar.gz\"" % remote_build_path)


@task
def relaunch_server(c, collectstatic=True, migrate=True):
    print("Relaunch server")
    do_relaunch_server(c, collectstatic, migrate)


@task
def create_virtualenv(c, version):

    print(t.green("create virtualenv for version ") + version)
    build_path, source_dep_list = build_source(c, c.env.key, version)
    print(t.green("BUILD PATH: ") + build_path + " - %r" % source_dep_list)

    source_dep_build_path_list = []
    print("Build dependencies : %r" %  source_dep_list)
    for source_dep_key, source_dep_version in source_dep_list:
        source_dep_build_path, _ = build_source(c, source_dep_key, source_dep_version)
        source_dep_build_path_list.append(source_dep_build_path)

    host_connection = Connection(c.env['hosts'][0])
    host_connection.run('mkdir -p "%s"' % c.env['remote_path']['build_export'])

    res_trans = sync_build(c, build_path)
    res_trans_dep = [ sync_build(c, source_dep_build_path).remote for source_dep_build_path in source_dep_build_path_list]
    # untar build
    print("Untar %s on remote host"%res_trans.remote)
    with host_connection.cd(c.env['remote_path']['build_export']):
        host_connection.run('tar zxf %s' % res_trans.remote)

    do_create_virtualenv(c, res_trans.remote[0:-7], res_trans_dep)

    host_connection.run('rm -fr "%s/*"' % (c.env['remote_path']['build_export']))
    clean_export_folder(c.env.remote_path['build_export'])


@task
def publish_version(c, version):
    create_virtualenv(c, version)
    relaunch_server(c, True, True)
