"""
Django settings for iconolab project.

Generated by 'django-admin startproject' using Django 1.9.5.

For more information on this file, see
https://docs.djangoproject.com/en/1.9/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.9/ref/settings/
"""

import os, logging, sys


# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

STATIC_ROOT = os.path.abspath(os.path.join(BASE_DIR, '../../web/static/site'))
MEDIA_ROOT = os.path.abspath(os.path.join(BASE_DIR, '../../web/media'))

BASE_URL = ''
STATIC_URL = '/static/'
MEDIA_URL = '/media/'

LOGIN_URL = '/account/login/'

#Static path


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.9/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '#8)+upuo3vc7fi15czxz53ml7*(1__q8hg=m&+9ylq&st1_kqv'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True
THUMBNAIL_DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    'iconolab_mcc',
    'iconolab.apps.IconolabApp',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',
    'django.contrib.humanize',
    'django_comments',
    'django_comments_xtd',
    'django_elasticsearch_dsl',
    'sorl.thumbnail',
    'notifications',
]

COMMENTS_APP = "django_comments_xtd"
COMMENTS_XTD_MODEL = "iconolab.models.IconolabComment"
COMMENTS_XTD_FORM_CLASS = 'iconolab.forms.comments.IconolabCommentForm'
COMMENTS_XTD_MAX_THREAD_LEVEL = 100
COMMENTS_PER_PAGE_DEFAULT = 10

SITE_ID = 1

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'iconolab_mcc.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(BASE_DIR,'iconolab_mcc', 'templates')],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'django.core.context_processors.media',
                'django.core.context_processors.static',
                'django.core.context_processors.i18n',
                'iconolab.utils.context_processors.env',
            ],
            'libraries': {
                'iconolab_mcc_tags':'iconolab_mcc.templatetags.iconolab_mcc_tags'
            }
        },
    },
]

WSGI_APPLICATION = 'iconolab_mcc.wsgi.application'


# Database
# https://docs.djangoproject.com/en/1.9/ref/settings/#databases
CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.filebased.FileBasedCache',
        'LOCATION': os.path.join(MEDIA_ROOT, 'cache'),
#        'BACKEND': 'django.core.cache.backends.memcached.MemcachedCache',
#        'LOCATION': 'unix:/var/run/memcached/memcached.socket',
#        'KEY_PREFIX': 'ldt',
    }
}
# Password validation
# https://docs.djangoproject.com/en/1.9/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/1.9/topics/i18n/

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


IMPORT_FIELDS_DICT = {
    "AUTR": [],
    "ECOLE": [],
    "TITR": ["Titre"],
    "DENO": [],
    "DOM": ["Domaine"],
    "APPL": [],
    "PERI": ["Période"],
    "MILL": [],
    "TECH": [],
    "DIMS": ["Dimensions"],
    "EPOQ": [],
    "LIEUX": [],
    "DECV": [],
    "LOCA": ["Localisation"],
    "PHOT": ["Photo"],
    "INV": ["No inventaire"],
    "REF": ["REFERENCE"],

}
IMPORT_DEFAULT_FIELD_TO_FILENAME_IDENTIFIER = "INV"
NO_IMG_CONVERSION_EXTS = [".jpg"]
IMG_CONVERSION_EXTS = [".tif", ".tiff"]
IMG_JPG_DEFAULT_QUALITY = 80
PREGENERATE_THUMBNAILS_SIZES = [
    # item_images_preview.html
    "250x250",
    "100x100",
]
IMPORT_LOG_FILE = ""
IMPORT_LOGGER_NAME = ""

DJANGO_RUNSERVER = (len(sys.argv)>1 and sys.argv[1] == 'runserver')

RELEVANT_TAGS_MIN_SCORE = 3
ACCURATE_TAGS_MIN_SCORE = 3

# The different thumbnail sizes that we want to pre-generate when importing or when updating collections using commands
# This allows to pre-calculate thumbnails for media-heavy pages such as collection_home

