from django.conf import settings
from django.template import Library

from iconolab_mcc import __version__

register = Library()

@register.simple_tag
def joconde_link(item_metadata):
    return settings.JOCONDE_NOTICE_BASE_URL + item_metadata.metadata_obj.get('joconde_ref', '').rjust(11, '0')

@register.simple_tag
def mcc_version():
    return __version__
