"""iconolab_episteme URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/2.0/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django import views as django_views
from django.conf import settings
from django.conf.urls.static import static
from django.contrib import admin
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from django.urls import include, path, re_path, reverse_lazy

import iconolab.urls

urlpatterns = [
    
    path('', include(iconolab.urls)),
    re_path(r'^$', django_views.generic.RedirectView.as_view(url=reverse_lazy("home"))),
    path('admin/', admin.site.urls),
    
    
]


if settings.DJANGO_RUNSERVER:
    urlpatterns += staticfiles_urlpatterns()
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
    #static url
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
