from django.contrib.auth.models import User
from django.conf.urls.defaults import url
from tastypie.resources import Bundle, ModelResource

class UserResource(ModelResource):
    class Meta:
        allowed_methods = ['get']
        queryset =  User.objects.all()
        resource_name = 'users'
    
    def override_urls(self):
        # WARNING : in tastypie <= 1.0, override_urls is used instead of prepend_urls. From 1.0.0, prepend_urls will be prefered and override_urls deprecated 
        return [
            url(r"^(?P<resource_name>%s)/(?P<username>[\w\d_.-]+)/$" % self._meta.resource_name, self.wrap_view('dispatch_detail'), name="api_dispatch_detail"),
        ]
    
    def get_resource_uri(self, bundle_or_obj):
        kwargs = {
            'resource_name': self._meta.resource_name,
            'api_name': self._meta.api_name
        }
        if isinstance(bundle_or_obj, Bundle):
            kwargs['username'] = bundle_or_obj.obj.username
        else:
            kwargs['username'] = bundle_or_obj.username
        return self._build_reverse_url("api_dispatch_detail", kwargs=kwargs)