# -*- coding: utf-8 -*-
'''
Created on Nov 14, 2012

@author: ymh
'''
import urlparse
import requests
from . import settings
import logging

logger = logging.getLogger(__name__)

def get_abs_url(url, default_domain):
    
    if not url:
        return url
    url_part = urlparse.urlparse(url)
    if url_part.netloc:
        return url
    else:
        pr = urlparse.ParseResult('http', default_domain, url_part.path, url_part.params, url_part.query, url_part.fragment)
        return pr.geturl()
    

def get_all_objects(res_url, field_filter):
    objects = []
    url = res_url
    while url:        
        r = requests.get(url)
        if r.status_code != requests.codes.ok: #@UndefinedVariable
            logger.error("Error when requesting objects " + repr(r.status_code) + " : " + repr(r.text))
            break
        objects.extend([ c for c in  r.json['objects'] if field_filter is None or c.get(field_filter, None) ])
        url = get_abs_url(r.json.get('meta',{}).get('next',None), settings.LDT_NETLOC)
    return objects


