# -*- coding: utf-8 -*-
'''
Created on Nov 13, 2012

@author: ymh
'''
import json
from django.http import HttpResponse, HttpResponseBadRequest
import requests
from django.conf import settings
import logging

logger = logging.getLogger(__name__)

def recommended(request):
    
    keywords_str = request.GET.get('keywords', None)

    if not keywords_str:
        return HttpResponseBadRequest("Error, null keywords")
    
    keywords = [kw.strip() for kw in keywords_str.split(",")]
    
    ldt_res = get_ldt_res(keywords)
    
    logger.debug("LDT results : " + repr(ldt_res) )
    
    kc_res = get_kc_res(keywords)
    
    res = mix_results(ldt_res, kc_res)
    
    return HttpResponse(json.dumps(res), content_type='application/json; charset=utf-8', )


def mix_results(ldt_res, kc_res):
    
    #TODO : implement mixin of results
    return ldt_res


def get_ldt_res(keywords):    
    
    recommended_url = settings.LDT_API_URL + "contents/recommended/"
    
    r = requests.get(recommended_url, params={'keywords':  ",".join(keywords)})
    logger.debug(repr(r))
    
    #TODO : manage error codes
    
    return r.json
    

def get_kc_res(keywords):
    
    #TODO : implement
    return None