# -*- coding: utf-8 -*-
'''
Created on Nov 14, 2012

@author: ymh
'''

from django import forms
from .models import VideoKCRel
import requests
from . import settings

class VideoKCRelForm(forms.ModelForm):
    
    iri_id = forms.CharField(max_length=255, widget=forms.widgets.Select()) 

    def __init__(self, *args, **kwargs):
        super(VideoKCRelForm, self).__init__(*args, **kwargs)
        
        url = settings.LDT_API_URL + "contents/"
        #limit=20&offset=20
        r = requests.get(url)        
        self.fields['iri_id'].widget.choices = [(content['iri_id'], content['title']) for content in r.json['objects']]
        
    class Meta:
        model = VideoKCRel
    