# -*- coding: utf-8 -*-
from south.v2 import DataMigration
from hp.utils import get_all_objects
from hp import settings

class Migration(DataMigration):

    def forwards(self, orm):
        url = settings.LDT_API_URL + "contents/"
        contents = get_all_objects(url, {'limit':settings.LDT_MAX_FETCH}, None)
        
        title_dict = dict([(c.get('iri_id',''), c.get('title','')) for c in contents])
        
        for rel in orm.VideoKCRel.objects.all():
            rel.content_title = title_dict.get(rel.iri_id,None)
            rel.save()

    def backwards(self, orm):
        for rel in orm.VideoKCRel.objects.all():
            rel.content_title = None
            rel.save()

    models = {
        'hp.videokcrel': {
            'Meta': {'object_name': 'VideoKCRel'},
            'content_title': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'graph_id': ('django.db.models.fields.CharField', [], {'max_length': '1024'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'iri_id': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '255'}),
            'project_id': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'topic_id': ('django.db.models.fields.CharField', [], {'max_length': '1024'})
        }
    }

    complete_apps = ['hp']
    symmetrical = True
