"""
Field classes.
"""

from django import forms
from django.utils.translation import ugettext_lazy as _
import logging
import time
import math

__all__ = (
    'LdtDurationField'
)

class LdtDurationField (forms.TimeField):
    default_error_messages = {
        'invalid': _(u'Enter a valid duration format'),
    }
    
    def __init__(self, formats, *args, **kwargs):
        self.formats = formats
        super(LdtDurationField, self).__init__(*args, **kwargs)
    
    def clean(self, data):
        dur = data
        for format in self.formats:
            try:
                dur = time.strptime(dur, format)
                dur = dur.tm_hour*3600 + dur.tm_min*60 + dur.tm_sec
                dur = dur*1000
                break
            except:
                logging.debug("trying next format")
        return dur