# -*- coding: utf-8 -*-
'''
Created on Nov 13, 2012

@author: ymh
'''

from django.db import models
from django.utils.translation import ugettext_lazy as _

class VideoKCRel(models.Model):
    
    iri_id = models.CharField(max_length=255, unique=True, verbose_name=_('content.iri_id'))
    project_id = models.CharField(max_length=255, unique=False, verbose_name=_('project_id'), null=True, blank=True)
    graph_id = models.CharField(max_length=1024, verbose_name=_('graph_id'))
    topic_id = models.CharField(max_length=1024, verbose_name=_('topic_id'))
    
    def __unicode__(self):
        return u"%s->%s|%s" %(self.iri_id,self.graph_id, self.topic_id)


