//////////    CONSTANTS    //////////
static final int   LABEL_LENGTH = 24;
static final float GAP   = 8;
static final float sigma = 0.01;
static final float FRAME           = 24;
static final float TICK            = 1;//0.5f;
static final float SPRING_LENGTH   = 100;
static final float SPRING_STRENGTH = 0.4; // 0.2;
static final float SPRING_DAMPING  = 0.4; // 0.2;
static final float SPACER_STRENGTH = 2000;
static final float DRAGFACTOR      = 0.2; //0.2
static final float REDUCE          = 1;
static final float MAX_DISTANCE    = 600;
static final float MIN_DISTANCE    = 24;//6;
static final float MAX_VELOCITY    = 48;//20; //8;

// mouse event
static final int   MOVED      =  1, 
                   DRAGGED    =  2, 
                   CLICKED    =  3,  
                   RELEASED   =  4; 
// touch event
static final int   MOVE        =  6,  
                   START       =  7,  
                   END         =  8;                    
// motion
static final int   HALT        = 11, 
                   MOVING      = 12, 
                   DRAGGING    = 13, 
                   DRAG        = 14, 
                   UP          = 15;
// action
static final int   NOOP        = 20, 
                   CLICK       = 21,  
                   RELEASE     = 22,  
                   DOUBLECLICK = 23, 
                   HOLDING     = 24, 
                   HOLDED      = 25; 
// node menu
static final int   EXPND       = 31, 
                   ROOT        = 32, 
                   FIX         = 33, 
                   FREE        = 34, 
                   HIDE        = 35, 
                   INFO        = 36, 
                   NEWREL      = 37,                    
                   NEWREL2     = 30, 
                   SQUEEZE     = 38, 
                   TOPIC       = 39; 
// application menu
static final int   FITALL      = 41, 
                   ALLFIX      = 42, 
                   ALLFREE     = 43, 
                   GROUPSHAPE  = 44, 
                   ALLSAVE     = 45, 
                   ALLRETRIEVE = 46, 
                   NEWTOPIC    = 47,
                   MODE        = 48,
                   PEDIA       = 49;
// edge menu
static final int   HIDEEDGE    = 51, 
                   EDITEDGE    = 52, 
                   DELETEEDGE  = 53;             

static final int AliceBlue         = #F0F8FF;
static final int AntiqueWhite      = #FAEBD7;
static final int Aqua              = #00FFFF;
static final int Aquamarine        = #7FFFD4;
static final int Azure             = #F0FFFF;
static final int Beige             = #F5F5DC;
static final int Bisque            = #FFE4C4;
static final int Black             = #000000;
static final int BlanchedAlmond    = #FFEBCD;
static final int Blue              = #0000FF;
static final int BlueViolet        = #8A2BE2;
static final int Brown             = #A52A2A;
static final int BurlyWood         = #DEB887;
static final int CadetBlue         = #5F9EA0;
static final int Chartreuse        = #7FFF00;
static final int Chocolate         = #D2691E;
static final int Coral             = #FF7F50;
static final int CornflowerBlue    = #6495ED;
static final int Cornsilk          = #FFF8DC;
static final int Crimson           = #DC143C;
static final int Cyan              = #00FFFF;
static final int DarkBlue          = #00008B;
static final int DarkCyan          = #008B8B;
static final int DarkGoldenRod     = #B8860B;
static final int DarkGray          = #A9A9A9;
static final int DarkGrey          = #A9A9A9;
static final int DarkGreen         = #006400;
static final int DarkKhaki         = #BDB76B;
static final int DarkMagenta       = #8B008B;
static final int DarkOliveGreen    = #556B2F;
static final int Darkorange        = #FF8C00;
static final int DarkOrchid        = #9932CC;
static final int DarkRed           = #8B0000;
static final int DarkSalmon        = #E9967A;
static final int DarkSeaGreen      = #8FBC8F;
static final int DarkSlateBlue     = #483D8B;
static final int DarkSlateGray     = #2F4F4F;
static final int DarkSlateGrey     = #2F4F4F;
static final int DarkTurquoise     = #00CED1;
static final int DarkViolet        = #9400D3;
static final int DeepPink          = #FF1493;
static final int DeepSkyBlue       = #00BFFF;
static final int DimGray           = #696969;
static final int DimGrey           = #696969;
static final int DodgerBlue        = #1E90FF;
static final int FireBrick         = #B22222;
static final int FloralWhite       = #FFFAF0;
static final int ForestGreen       = #228B22;
static final int Fuchsia           = #FF00FF;
static final int Gainsboro         = #DCDCDC;
static final int GhostWhite        = #F8F8FF;
static final int Gold              = #FFD700;
static final int GoldenRod         = #DAA520;
static final int Gray              = #808080;
static final int Grey              = #808080;
static final int Green             = #008000;
static final int GreenYellow       = #ADFF2F;
static final int HoneyDew          = #F0FFF0;
static final int HotPink           = #FF69B4;
static final int IndianRed         = #CD5C5C;
static final int Indigo            = #4B0082;
static final int Ivory             = #FFFFF0;
static final int Khaki             = #F0E68C;
static final int Lavender          = #E6E6FA;
static final int LavenderBlush     = #FFF0F5;
static final int LawnGreen         = #7CFC00;
static final int LemonChiffon      = #FFFACD;
static final int LightBlue         = #ADD8E6;
static final int LightCoral        = #F08080;
static final int LightCyan         = #E0FFFF;
static final int LightGoldenRodYellow = #FAFAD2;
static final int LightGray         = #D3D3D3;
static final int LightGrey         = #D3D3D3;
static final int LightGreen        = #90EE90;
static final int LightPink         = #FFB6C1;
static final int LightSalmon       = #FFA07A;
static final int LightSeaGreen     = #20B2AA;
static final int LightSkyBlue      = #87CEFA;
static final int LightSlateGray    = #778899;
static final int LightSlateGrey    = #778899;
static final int LightSteelBlue    = #B0C4DE;
static final int LightYellow       = #FFFFE0;
static final int Lime              = #00FF00;
static final int LimeGreen         = #32CD32;
static final int Linen             = #FAF0E6;
static final int Magenta           = #FF00FF;
static final int Maroon            = #800000;
static final int MediumAquaMarine  = #66CDAA;
static final int MediumBlue        = #0000CD;
static final int MediumOrchid      = #BA55D3;
static final int MediumPurple      = #9370D8;
static final int MediumSeaGreen    = #3CB371;
static final int MediumSlateBlue   = #7B68EE;
static final int MediumSpringGreen = #00FA9A;
static final int MediumTurquoise   = #48D1CC;
static final int MediumVioletRed   = #C71585;
static final int MidnightBlue      = #191970;
static final int MintCream         = #F5FFFA;
static final int MistyRose         = #FFE4E1;
static final int Moccasin          = #FFE4B5;
static final int NavajoWhite       = #FFDEAD;
static final int Navy              = #000080;
static final int OldLace           = #FDF5E6;
static final int Olive             = #808000;
static final int OliveDrab         = #6B8E23;
static final int Orange            = #FFA500;
static final int OrangeRed         = #FF4500;
static final int Orchid            = #DA70D6;
static final int PaleGoldenRod     = #EEE8AA;
static final int PaleGreen         = #98FB98;
static final int PaleTurquoise     = #AFEEEE;
static final int PaleVioletRed     = #D87093;
static final int PapayaWhip        = #FFEFD5;
static final int PeachPuff         = #FFDAB9;
static final int Peru              = #CD853F;
static final int Pink              = #FFC0CB;
static final int Plum              = #DDA0DD;
static final int PowderBlue        = #B0E0E6;
static final int Purple            = #800080;
static final int Red               = #FF0000;
static final int RosyBrown         = #BC8F8F;
static final int RoyalBlue         = #4169E1;
static final int SaddleBrown       = #8B4513;
static final int Salmon            = #FA8072;
static final int SandyBrown        = #F4A460;
static final int SeaGreen          = #2E8B57;
static final int SeaShell          = #FFF5EE;
static final int Sienna            = #A0522D;
static final int Silver            = #C0C0C0;
static final int SkyBlue           = #87CEEB;
static final int SlateBlue         = #6A5ACD;
static final int SlateGray         = #708090;
static final int SlateGrey         = #708090;
static final int Snow              = #FFFAFA;
static final int SpringGreen       = #00FF7F;
static final int SteelBlue         = #4682B4;
static final int Tan               = #D2B48C;
static final int Teal              = #008080;
static final int Thistle           = #D8BFD8;
static final int Tomato            = #FF6347;
static final int Turquoise         = #40E0D0;
static final int Violet            = #EE82EE;
static final int Wheat             = #F5DEB3;
static final int White             = #FFFFFF;
static final int WhiteSmoke        = #F5F5F5;
static final int Yellow            = #FFFF00;
static final int YellowGreen       = #9ACD32;

static final color nodeColor     = LightYellow;
static final color selectColor   = Gold;
static final color selectedColor = SpringGreen;
static final color rootColor     = Darkorange;
static final color fixedColor    = HotPink;
static final color edgeColor     = 0xFF80A0A0;

////////// TO STRING ///////////////////////////////////////////////
String toStr(int i) {
  switch(i) {
// Event
    case MOVED:       return "MOVED";
    case DRAGGED:     return "DRAGGED";
    case CLICKED:     return "CLICKED";
    case RELEASED:    return "RELEASED";
    case START:       return "START";
    case MOVE:        return "MOVE";
    case END:         return "END";
// Motion
    case HALT:        return "HALT";
    case MOVING:      return "MOVING";
    case DRAGGING:    return "DRAGGING";
    case DRAG:        return "DRAG";
// Action
    case NOOP:        return "NOOP";
    case CLICK:       return "CLICK";
    case RELEASE:     return "RELEASE";
    case DOUBLECLICK: return "DOUBLECLICK";
    case HOLDING:     return "HOLDING";
    case HOLDED:      return "HOLDED";
    default:          return "";
// menu
    case EXPND:       return "EXPAND";
    case ROOT:        return "ROOT";
    case FIX:         return "FIX";
    case FREE:        return "FREE";
    case HIDE:        return "HIDE";
    case INFO:        return "INFO";
    case NEWREL:      return "NEWREL";    
    case NEWREL2:     return "NEWREL2";
    case SQUEEZE:     return "SQUEEZE";
    case TOPIC:       return "TOPIC";
// apmenu
    case FITALL:      return "FITALL";
    case ALLFIX:      return "ALLFIX";
    case ALLFREE:     return "ALLFREE";
    case GROUPSHAPE:  return "GROUPSHAPE";
    case ALLSAVE:     return "ALLSAVE";
    case ALLRETRIEVE: return "ALLRETRIEVE";
    case NEWTOPIC:    return "NEWTOPIC";
  }
}


